/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer.texture;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import org.tlauncher.minecraft.GameTextureManager;
import org.tlauncher.renderer.image.ImageWrap;
import org.tlauncher.renderer.texture.LightTexture;
import org.tlauncher.util.reflection.ResourceLocationUtils;

public class FramedTexture {
    private static int FRAME_COUNTER;
    private int currentFrameIndex;
    private long lastTimeNano = System.nanoTime();
    private final long updatingTextureInNano;
    private final boolean animated;
    private List<class_2960> frames;

    public FramedTexture(long updatingTextureInNano, boolean animated) {
        this.updatingTextureInNano = updatingTextureInNano;
        this.frames = new ArrayList<class_2960>();
        this.animated = animated;
    }

    public FramedTexture(int framesSize, long updatingTextureInNano, boolean animated) {
        this(updatingTextureInNano, animated);
        this.frames = new ArrayList<class_2960>(framesSize);
    }

    public static FramedTexture createOneFramedTexture(GameTextureManager gameTextureManager, ImageWrap imageWrap) {
        FramedTexture texture = new FramedTexture(1L, false);
        class_2960 resourceLocation = ResourceLocationUtils.resourceLocation(String.format("dynamic/framedtexture%s.png", FramedTexture.getNextFrameIndex()));
        LightTexture lightTexture = new LightTexture(imageWrap);
        gameTextureManager.loadTexture(resourceLocation, lightTexture);
        texture.frames.add(resourceLocation);
        return texture;
    }

    public void initByOneImage(GameTextureManager gameTextureManager, ImageWrap imageWrap) {
        class_2960 res = ResourceLocationUtils.resourceLocation("dynamic/framedtexture" + FramedTexture.getNextFrameIndex() + ".png");
        LightTexture lightTexture = new LightTexture(imageWrap);
        gameTextureManager.loadTexture(res, lightTexture);
        this.frames.add(res);
    }

    public class_2960 getFirstFrame() {
        return this.frames.get(0);
    }

    private static int getNextFrameIndex() {
        return ++FRAME_COUNTER;
    }

    public class_2960 getFrame() {
        if (!this.animated) {
            return this.getFirstFrame();
        }
        if (System.nanoTime() - this.lastTimeNano >= this.updatingTextureInNano) {
            this.lastTimeNano = System.nanoTime();
            this.currentFrameIndex = this.currentFrameIndex + 1 < this.frames.size() ? ++this.currentFrameIndex : 0;
        }
        return this.frames.get(this.currentFrameIndex);
    }

    public int getCurrentFrameIndex() {
        return this.currentFrameIndex;
    }

    public List<class_2960> getFrames() {
        return this.frames;
    }
}

