/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.service;

import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.GsonService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Objects;
import org.tlauncher.configuration.ModConfiguration;

public class ModService {
    private final ModConfiguration modConfiguration;

    public <T> T getProfile(String uri, Type t) throws Exception {
        GsonService gs = this.modConfiguration.getGsonService();
        try {
            return gs.getObjectByUrls(this.modConfiguration.getDomains(), uri, t, false);
        }
        catch (Exception e) {
            Object res = gs.getLocalObject(this.modConfiguration.getDomains(), uri, t);
            if (Objects.isNull(res)) {
                throw e;
            }
            return res;
        }
    }

    public Path getImageFile(String uri) throws IOException, NoSuchAlgorithmException {
        FileCacheService fcs = this.modConfiguration.getFileCacheService();
        try {
            ArrayList domains = this.modConfiguration.getDomains();
            if (uri.startsWith("http")) {
                int domainEnd = uri.indexOf("/", 9) + 1;
                domains = Lists.newArrayList((Object[])new String[]{uri.substring(0, domainEnd)});
                uri = uri.substring(domainEnd, uri.length());
            }
            return fcs.getRawObject(domains, uri, false);
        }
        catch (Exception e) {
            Path res = fcs.getLocalRawObject(this.modConfiguration.getDomains(), uri);
            if (Objects.isNull(res)) {
                throw e;
            }
            return res;
        }
    }

    public ModService(ModConfiguration modConfiguration) {
        this.modConfiguration = modConfiguration;
    }
}

