/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

public class MinecraftVersion {
    private final String version;
    private final int versionIndex;
    private final boolean isForge;
    private final boolean isFabric;

    public MinecraftVersion(String version) {
        this.version = version.replaceFirst("(forge|fabric)", "");
        this.versionIndex = this.genVersionIndex(version);
        this.isForge = version.startsWith("forge");
        this.isFabric = version.startsWith("fabric");
    }

    public boolean isGreaterThanOrEquals(String version) {
        return this.versionIndex >= this.genVersionIndex(version);
    }

    public boolean isLowerThanOrEquals(String version) {
        return this.versionIndex <= this.genVersionIndex(version);
    }

    private int genVersionIndex(String version) {
        int startIndex = 0;
        while (!Character.isDigit(version.charAt(startIndex))) {
            ++startIndex;
        }
        String clearVersion = startIndex > 0 ? version.substring(startIndex) : version;
        String[] splittedVersion = clearVersion.split("\\.");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            String part = i < splittedVersion.length ? splittedVersion[i] : "0";
            result.append((String)(part.length() == 1 ? "0" + part : part));
        }
        return Integer.parseInt(result.toString());
    }

    public boolean equals(String version) {
        return this.version.equals(version);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionIndex() {
        return this.versionIndex;
    }

    public boolean isForge() {
        return this.isForge;
    }

    public boolean isFabric() {
        return this.isFabric;
    }
}

