/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.lib.AdornGameRules;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class KitchenSinkBlockEntity
extends class_2586 {
    public KitchenSinkBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)AdornBlockEntities.KITCHEN_SINK.get(), pos, state);
    }

    public abstract FluidReference getFluidReference();

    public abstract boolean interactWithItem(class_1799 var1, class_1657 var2, class_1268 var3);

    public abstract boolean clearFluidsWithSponge();

    protected void onFill(class_1799 stack, class_1657 player) {
        this.field_11863.method_33596((class_1297)player, (class_6880)class_5712.field_28166, this.field_11867);
        player.method_5783(this.getEmptySound((FluidReference)this.getFluidReference(), (class_1799)stack).event, 1.0f, 1.0f);
    }

    protected void onPickUp(FluidReference fluid, class_1799 stack, class_1657 player) {
        this.field_11863.method_33596((class_1297)player, (class_6880)class_5712.field_28167, this.field_11867);
        player.method_37908().method_43128((class_1297)player, player.method_23317(), player.method_23318(), player.method_23321(), this.getFillSound((FluidReference)fluid, (class_1799)stack).event, class_3419.field_15245, 1.0f, 1.0f);
    }

    protected FluidItemSound getFillSound(FluidReference fluid, class_1799 stack) {
        if (stack.method_31574(class_1802.field_8469)) {
            return new FluidItemSound(class_3417.field_14779, true);
        }
        return new FluidItemSound(fluid.getFluid().method_32359().orElse(class_3417.field_15126), false);
    }

    protected FluidItemSound getEmptySound(FluidReference fluid, class_1799 stack) {
        if (KitchenSinkBlockEntity.isWaterBottle(stack)) {
            return new FluidItemSound(class_3417.field_14826, true);
        }
        return new FluidItemSound(fluid.getFluid().method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834, false);
    }

    protected static boolean isWaterBottle(class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8574)) {
            return false;
        }
        class_1844 potionContents = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        return potionContents.method_57401(class_1847.field_8991);
    }

    protected void markDirtyAndSync() {
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_58692(registries);
    }

    public abstract int calculateComparatorOutput();

    private static boolean isInfinite(class_3611 fluid, class_3218 world) {
        class_3609 flowable;
        return fluid instanceof class_3609 && (flowable = (class_3609)fluid).method_15737(world);
    }

    public static boolean supportsInfiniteExtraction(class_3218 world, class_3611 fluid) {
        return KitchenSinkBlockEntity.isInfinite(fluid, world) && world.method_64395().method_8355(AdornGameRules.INFINITE_KITCHEN_SINKS);
    }

    public record FluidItemSound(class_3414 event, boolean preferred) {
        public FluidItemSound orElse(@Nullable class_3414 fallback) {
            if (this.preferred) {
                return this;
            }
            return fallback != null ? new FluidItemSound(fallback, true) : this;
        }
    }
}

