/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.recipe;

import java.util.Objects;
import java.util.Optional;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public final class BrewingRecipeJsonBuilder {
    private final class_7871<class_1792> itemLookup;
    private final class_1799 result;
    @Nullable
    private class_1856 firstIngredient;
    @Nullable
    private class_1856 secondIngredient;
    @Nullable
    private FluidIngredient fluid;

    private BrewingRecipeJsonBuilder(class_7871<class_1792> itemLookup, class_1799 result) {
        this.itemLookup = itemLookup;
        this.result = result;
    }

    public static BrewingRecipeJsonBuilder create(class_7871<class_1792> itemLookup, class_1935 item) {
        return BrewingRecipeJsonBuilder.create(itemLookup, item, 1);
    }

    public static BrewingRecipeJsonBuilder create(class_7871<class_1792> itemLookup, class_1935 item, int count) {
        return new BrewingRecipeJsonBuilder(itemLookup, new class_1799(item, count));
    }

    public BrewingRecipeJsonBuilder first(class_1935 item) {
        this.firstIngredient = class_1856.method_8101((class_1935)item);
        return this;
    }

    public BrewingRecipeJsonBuilder first(class_6862<class_1792> tag) {
        this.firstIngredient = class_1856.method_8106((class_6885)this.itemLookup.method_46735(tag));
        return this;
    }

    public BrewingRecipeJsonBuilder second(class_1935 item) {
        this.secondIngredient = class_1856.method_8101((class_1935)item);
        return this;
    }

    public BrewingRecipeJsonBuilder second(class_6862<class_1792> tag) {
        this.secondIngredient = class_1856.method_8106((class_6885)this.itemLookup.method_46735(tag));
        return this;
    }

    public BrewingRecipeJsonBuilder fluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public void offerTo(class_8790 exporter) {
        this.offerTo(exporter, class_5797.method_36442((class_1935)this.result.method_7909()).method_12832());
    }

    public void offerTo(class_8790 exporter, String recipeName) {
        Objects.requireNonNull(this.firstIngredient, "First ingredient of brewing recipe not set");
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)AdornCommon.id("brewing/" + recipeName));
        Record recipe = this.fluid != null ? new FluidBrewingRecipe(this.firstIngredient, Optional.ofNullable(this.secondIngredient), this.fluid, this.result) : new ItemBrewingRecipe(this.firstIngredient, Optional.ofNullable(this.secondIngredient), this.result);
        exporter.method_53819(key, (class_1860)recipe, null);
    }
}

