/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.recipe;

import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.item.WateringCanItem;
import juuxel.adorn.lib.AdornTags;
import juuxel.adorn.recipe.AdornRecipeSerializers;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9331;
import net.minecraft.class_9694;
import org.jetbrains.annotations.Nullable;

public final class FertilizerRefillingRecipe
extends class_1852 {
    public FertilizerRefillingRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 world) {
        return this.match(input) != null;
    }

    public class_1799 craft(class_9694 input, class_7225.class_7874 registries) {
        MatchResult match = this.match(input);
        if (match == null) {
            return class_1799.field_8037;
        }
        class_1799 result = match.wateringCan().method_7972();
        int fertilizerLevel = WateringCanItem.FertilizerLevel.get(result);
        int newFertilizerLevel = Math.min(fertilizerLevel + match.fertilizers(), 32);
        result.method_57379((class_9331)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)WateringCanItem.FertilizerLevel.of(newFertilizerLevel));
        return result;
    }

    @Nullable
    private MatchResult match(class_9694 inventory) {
        class_1799 wateringCan = class_1799.field_8037;
        int fertilizers = 0;
        for (int slot = 0; slot < inventory.method_59983(); ++slot) {
            class_1799 stack = inventory.method_59984(slot);
            if (stack.method_31574((class_1792)AdornItems.WATERING_CAN.get())) {
                if (wateringCan.method_7960()) {
                    wateringCan = stack;
                    continue;
                }
                return null;
            }
            if (stack.method_7960()) continue;
            if (stack.method_31573(AdornTags.WATERING_CAN_FERTILIZERS)) {
                ++fertilizers;
                continue;
            }
            return null;
        }
        if (wateringCan.method_7960() || fertilizers == 0) {
            return null;
        }
        return new MatchResult(wateringCan, fertilizers);
    }

    public class_1865<FertilizerRefillingRecipe> method_8119() {
        return (class_1865)AdornRecipeSerializers.FERTILIZER_REFILLING.get();
    }

    private record MatchResult(class_1799 wateringCan, int fertilizers) {
    }
}

