/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util.animation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import juuxel.adorn.util.animation.AnimationTask;
import org.jetbrains.annotations.Nullable;

public final class AnimationEngine {
    private final List<AnimationTask> tasks = new ArrayList<AnimationTask>();
    @Nullable
    private AnimatorThread thread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AnimationTask task) {
        List<AnimationTask> list = this.tasks;
        synchronized (list) {
            this.tasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AnimationTask task) {
        List<AnimationTask> list = this.tasks;
        synchronized (list) {
            this.tasks.remove(task);
        }
    }

    public void start() {
        if (this.thread == null) {
            AnimatorThread thread = new AnimatorThread();
            thread.start();
            this.thread = thread;
        }
    }

    public void stop() {
        AnimatorThread current = this.thread;
        if (current != null) {
            current.interrupt();
        }
        this.thread = null;
    }

    private final class AnimatorThread
    extends Thread {
        private AnimatorThread() {
            super("Adorn animator");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!AnimatorThread.interrupted()) {
                List<AnimationTask> list = AnimationEngine.this.tasks;
                synchronized (list) {
                    Iterator<AnimationTask> iter = AnimationEngine.this.tasks.iterator();
                    while (iter.hasNext()) {
                        AnimationTask task = iter.next();
                        if (task.isAlive()) {
                            task.tick();
                            continue;
                        }
                        task.removed();
                        iter.remove();
                    }
                }
                try {
                    AnimatorThread.sleep(10L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

