/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantHelper;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10355;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_314;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import net.minecraft.class_9887;

public class DynamicFurnitureRecipe
implements FurnitureRecipe {
    private final String group;
    private final FurnitureOutput furnitureOutput;
    private final List<class_2960> supportedVariants;
    private final FurnitureIngredients ingredients;
    Map<class_2960, List<FurnitureInnerRecipe>> furnitureInnerRecipes = Maps.newHashMap();
    Map<class_1799, FurnitureInnerRecipe> outputToInnerRecipe = new HashMap<class_1799, FurnitureInnerRecipe>();
    Map<class_1792, FurnitureInnerRecipe> outputItemToInnerRecipe = new HashMap<class_1792, FurnitureInnerRecipe>();

    public DynamicFurnitureRecipe(String group, FurnitureOutput furnitureOutput, List<class_2960> supportedVariants, FurnitureIngredients furnitureIngredients) {
        this.group = group;
        this.furnitureOutput = furnitureOutput;
        this.supportedVariants = supportedVariants;
        this.ingredients = furnitureIngredients;
    }

    public void constructInnerRecipes() {
        if (!this.furnitureInnerRecipes.isEmpty()) {
            return;
        }
        for (class_2960 id : this.supportedVariants) {
            WoodVariant woodVariant;
            Optional<class_2248> optionalOutput;
            VariantBase<?> variant = VariantHelper.getVariant(id);
            if (variant == null || this.furnitureInnerRecipes.containsKey(id)) continue;
            class_9326 componentChanges = this.furnitureOutput.components != null ? this.furnitureOutput.components : class_9326.field_49588;
            class_9323.class_9324 builder = class_9323.method_57827();
            if (!componentChanges.method_57848() && componentChanges.method_57846().stream().anyMatch(dataComponentTypeOptionalEntry -> dataComponentTypeOptionalEntry.getKey() == PFMComponents.COLOR_COMPONENT)) {
                optionalOutput = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariantAndColor(variant, (class_1767)componentChanges.method_57845(PFMComponents.COLOR_COMPONENT).get());
                if (optionalOutput.get().method_8389().method_57347().method_58694(PFMComponents.COLOR_COMPONENT) == null) {
                    componentChanges = componentChanges.method_58757(dataComponentType -> dataComponentType == PFMComponents.COLOR_COMPONENT);
                    class_9335.method_57935((class_9323)optionalOutput.get().method_8389().method_57347(), (class_9326)componentChanges);
                } else {
                    builder.method_57839((class_9323)class_9335.method_57935((class_9323)optionalOutput.get().method_8389().method_57347(), (class_9326)componentChanges));
                }
            } else {
                optionalOutput = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariant(variant);
                builder.method_57839((class_9323)class_9335.method_57935((class_9323)optionalOutput.get().method_8389().method_57347(), (class_9326)componentChanges));
            }
            if (optionalOutput.isEmpty()) continue;
            if (optionalOutput.get().method_8389().method_57347().method_58694(PFMComponents.VARIANT_COMPONENT) != null) {
                builder.method_57840(PFMComponents.VARIANT_COMPONENT, (Object)variant.identifier);
            }
            class_1799 output = new class_1799((class_1935)optionalOutput.get().method_8389(), this.furnitureOutput.getOutputCount());
            class_9323 finalComponents = builder.method_57838();
            if (!finalComponents.method_57837()) {
                output.method_57365(builder.method_57838());
            }
            Map<String, Integer> childrenToCountMap = this.ingredients.variantChildren;
            boolean abortVariant = false;
            ArrayList<class_1856> stacks = new ArrayList<class_1856>();
            for (Map.Entry<String, Integer> entry : childrenToCountMap.entrySet()) {
                class_1935 convertible = variant.getItemForRecipe(entry.getKey(), this.getOutputBlockClass());
                if (convertible == null || convertible.method_8389() == class_1802.field_8162) {
                    abortVariant = true;
                    break;
                }
                for (int i = 0; i < entry.getValue(); ++i) {
                    stacks.add(class_1856.method_8101((class_1935)convertible.method_8389()));
                }
            }
            if (abortVariant) {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Skipped constructing inner recipe for variant {} on recipe {}", (Object)variant.identifier, (Object)this.furnitureOutput.outputClass);
                continue;
            }
            ArrayList<FurnitureInnerRecipe> recipes = new ArrayList<FurnitureInnerRecipe>();
            FurnitureInnerRecipe recipe = new FurnitureInnerRecipe(this, output, stacks);
            recipes.add(recipe);
            if (variant instanceof WoodVariant && (woodVariant = (WoodVariant)variant).hasStripped()) {
                ArrayList<class_1856> strippedIngredients = new ArrayList<class_1856>();
                for (Map.Entry<String, Integer> entry : childrenToCountMap.entrySet()) {
                    for (int i = 0; i < entry.getValue(); ++i) {
                        if (this.getOutputBlockClass() == RawLogTableBlock.class) {
                            strippedIngredients.add(class_1856.method_8091((class_1935[])new class_1935[]{(class_2248)woodVariant.getChild("stripped_log")}));
                            continue;
                        }
                        strippedIngredients.add(class_1856.method_8101((class_1935)woodVariant.getItemForRecipe(entry.getKey(), this.getOutputBlockClass(), true).method_8389()));
                    }
                }
                Optional<class_2248> strippedOptional = PaladinFurnitureMod.furnitureEntryMap.get(this.getOutputBlockClass()).getEntryFromVariant(variant, true);
                if (strippedOptional.isPresent()) {
                    class_1799 strippedOutput = new class_1799((class_1935)strippedOptional.get(), this.furnitureOutput.getOutputCount());
                    if (!finalComponents.method_57837()) {
                        strippedOutput.method_57365(finalComponents);
                    }
                    FurnitureInnerRecipe stripped = new FurnitureInnerRecipe(this, strippedOutput, strippedIngredients);
                    recipes.add(stripped);
                }
            }
            this.furnitureInnerRecipes.put(id, recipes);
        }
    }

    public boolean matches(FurnitureRecipe.FurnitureRecipeInput inventory, class_1937 world) {
        this.constructInnerRecipes();
        for (class_2960 id : this.furnitureInnerRecipes.keySet()) {
            List<FurnitureInnerRecipe> recipes = this.furnitureInnerRecipes.get(id);
            for (FurnitureInnerRecipe recipe : recipes) {
                if (!recipe.isInnerEnabled(world.method_45162()) || !recipe.matches(inventory, world)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<FurnitureRecipe.CraftableFurnitureRecipe> getAvailableOutputs(FurnitureRecipe.FurnitureRecipeInput input, class_7225.class_7874 registryManager) {
        this.constructInnerRecipes();
        class_1661 inventory = input.playerInventory();
        ArrayList stacks = Lists.newArrayList();
        for (class_2960 id : this.furnitureInnerRecipes.keySet()) {
            List<FurnitureInnerRecipe> recipes = this.furnitureInnerRecipes.get(id);
            for (FurnitureInnerRecipe recipe : recipes) {
                if (!recipe.isInnerEnabled(inventory.field_7546.method_37908().method_45162()) || !recipe.matches(input, inventory.field_7546.method_37908())) continue;
                stacks.add(recipe);
            }
        }
        return stacks;
    }

    @Override
    public List<FurnitureRecipe.CraftableFurnitureRecipe> getInnerRecipes(class_7699 featureSet) {
        this.constructInnerRecipes();
        ArrayList<FurnitureRecipe.CraftableFurnitureRecipe> outputs = new ArrayList<FurnitureRecipe.CraftableFurnitureRecipe>();
        for (List<FurnitureInnerRecipe> recipes : this.furnitureInnerRecipes.values()) {
            for (FurnitureInnerRecipe recipe : recipes) {
                if (featureSet != null && recipe.isInnerEnabled(featureSet)) {
                    outputs.add(recipe);
                    continue;
                }
                if (featureSet != null) continue;
                outputs.add(recipe);
            }
        }
        return outputs;
    }

    @Override
    public String outputClass() {
        return this.furnitureOutput.outputClass;
    }

    public class_1799 craft(FurnitureRecipe.FurnitureRecipeInput inventory, class_7225.class_7874 registryManager) {
        PaladinFurnitureMod.GENERAL_LOGGER.warn("Something has tried to craft a dynamic furniture recipe without context");
        return class_1799.field_8037;
    }

    @Override
    public class_1799 getResult(class_7225.class_7874 registryManager) {
        PaladinFurnitureMod.GENERAL_LOGGER.warn("Something has tried to get the output of a dynamic furniture recipe without context");
        return class_1799.field_8037;
    }

    public class_1865<? extends class_1860<FurnitureRecipe.FurnitureRecipeInput>> method_8119() {
        return RecipeTypes.DYNAMIC_FURNITURE_SERIALIZER;
    }

    public class_9887 method_61671() {
        ArrayList<class_1856> ingredientList = new ArrayList<class_1856>();
        for (FurnitureRecipe.CraftableFurnitureRecipe recipe : this.getInnerRecipes(null)) {
            ingredientList.addAll(recipe.getIngredients());
        }
        return class_9887.method_61683(ingredientList.stream().map(Optional::of).toList());
    }

    public class_10355 method_64668() {
        return class_314.field_1810;
    }

    protected Class<? extends class_2248> getOutputBlockClass() {
        return FurnitureOutput.getOutputBlockClass(this.furnitureOutput.outputClass);
    }

    public List<class_2960> getSupportedVariants() {
        return this.supportedVariants;
    }

    @Override
    public int getOutputCount(class_7225.class_7874 registryManager) {
        return this.furnitureOutput.getOutputCount();
    }

    @Override
    public int getMaxInnerRecipeSize() {
        return this.ingredients.vanillaIngredients.size() + this.ingredients.variantChildren.size();
    }

    @Override
    public List<? extends FurnitureRecipe.CraftableFurnitureRecipe> getInnerRecipesForVariant(class_1937 world, class_2960 identifier) {
        this.constructInnerRecipes();
        if (this.furnitureInnerRecipes.containsKey(identifier)) {
            return this.furnitureInnerRecipes.get(identifier);
        }
        return List.of();
    }

    @Override
    public void write(class_9129 buf) {
        Serializer.write(buf, this);
    }

    @Override
    public String getName(class_7225.class_7874 registryManager) {
        return this.outputClass().replaceAll("(?<=[a-z])(?=[A-Z])", " ");
    }

    private FurnitureOutput getOutput() {
        return this.furnitureOutput;
    }

    private FurnitureIngredients getInnerIngredients() {
        return this.ingredients;
    }

    @Override
    public List<class_1856> getIngredients(class_1937 world) {
        ArrayList<class_1856> ingredientList = new ArrayList<class_1856>();
        for (FurnitureRecipe.CraftableFurnitureRecipe recipe : this.getInnerRecipes(world.method_45162())) {
            ingredientList.addAll(recipe.getIngredients());
        }
        return ingredientList;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DynamicFurnitureRecipe)) {
            return false;
        }
        DynamicFurnitureRecipe that = (DynamicFurnitureRecipe)object;
        return Objects.equals(this.group, that.group) && this.furnitureOutput.equals(that.furnitureOutput) && this.ingredients.equals(that.ingredients);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.furnitureOutput, this.ingredients);
    }

    public static class FurnitureOutput {
        public static MapCodec<FurnitureOutput> CODEC = RecordCodecBuilder.mapCodec(furnitureOutputInstance -> furnitureOutputInstance.group((App)Codec.STRING.fieldOf("outputClass").forGetter(out -> out.outputClass), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(out -> out.outputCount), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(out -> out.components)).apply((Applicative)furnitureOutputInstance, FurnitureOutput::new));
        private final String outputClass;
        private final int outputCount;
        private final class_9326 components;

        public FurnitureOutput(String outputClass, int outputCount, class_9326 components) {
            this.outputClass = outputClass;
            this.outputCount = outputCount;
            this.components = components;
        }

        public int getOutputCount() {
            return this.outputCount;
        }

        public class_9326 getComponents() {
            return this.components;
        }

        public String getOutputClass() {
            return this.outputClass;
        }

        public static FurnitureOutput read(class_9129 buf) {
            String outputClass = buf.method_19772();
            int count = buf.readInt();
            class_9326 componentChanges = (class_9326)class_9326.field_49590.decode((Object)buf);
            return new FurnitureOutput(outputClass, count, componentChanges);
        }

        public static void write(class_9129 buf, FurnitureOutput output) {
            buf.method_10814(output.outputClass);
            buf.method_53002(output.outputCount);
            class_9326.field_49590.encode((Object)buf, (Object)output.components);
        }

        public static Class<? extends class_2248> getOutputBlockClass(String outputClass) {
            try {
                return Class.forName("com.unlikepaladin.pfm.blocks." + outputClass);
            }
            catch (ClassCastException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FurnitureOutput)) {
                return false;
            }
            FurnitureOutput that = (FurnitureOutput)object;
            return this.outputCount == that.outputCount && Objects.equals(this.outputClass, that.outputClass) && Objects.equals(this.components, that.components);
        }

        public int hashCode() {
            return Objects.hash(this.outputClass, this.outputCount, this.components);
        }
    }

    public static final class FurnitureIngredients {
        public static Codec<FurnitureIngredients> CODEC = RecordCodecBuilder.create(furnitureIngredientsInstance -> furnitureIngredientsInstance.group((App)class_1856.field_46095.listOf().optionalFieldOf("vanillaIngredients", new ArrayList()).forGetter(ingredients -> ingredients.vanillaIngredients), (App)class_5699.method_53703((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("variantChildren").forGetter(ingredients -> ingredients.variantChildren)).apply((Applicative)furnitureIngredientsInstance, FurnitureIngredients::new));
        private final List<class_1856> vanillaIngredients;
        private final Map<String, Integer> variantChildren;

        public FurnitureIngredients(List<class_1856> vanillaIngredients, Map<String, Integer> variantChildren) {
            this.vanillaIngredients = vanillaIngredients;
            this.variantChildren = variantChildren;
        }

        public static FurnitureIngredients read(class_9129 buf) {
            List vanillaIngredients = (List)buf.method_34068(Lists::newArrayListWithCapacity, buf1 -> (class_1856)class_1856.field_48355.decode((Object)buf));
            Map variantChildren = buf.method_34067(class_2540::method_19772, class_2540::readInt);
            return new FurnitureIngredients(vanillaIngredients, variantChildren);
        }

        public static void write(class_9129 buf, FurnitureIngredients ingredients) {
            buf.method_34062(ingredients.vanillaIngredients, (packetByteBuf, ingredient) -> class_1856.field_48355.encode((Object)((class_9129)packetByteBuf), ingredient));
            buf.method_34063(ingredients.variantChildren, class_2540::method_10814, class_2540::method_53002);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FurnitureIngredients)) {
                return false;
            }
            FurnitureIngredients that = (FurnitureIngredients)object;
            return Objects.equals(this.vanillaIngredients, that.vanillaIngredients) && Objects.equals(this.variantChildren, that.variantChildren);
        }

        public int hashCode() {
            return Objects.hash(this.vanillaIngredients, this.variantChildren);
        }
    }

    public static final class FurnitureInnerRecipe
    implements FurnitureRecipe.CraftableFurnitureRecipe {
        private final DynamicFurnitureRecipe parentRecipe;
        private final class_1799 output;
        private final List<class_1856> ingredients;
        private final List<class_1856> combinedIngredients;

        public FurnitureInnerRecipe(DynamicFurnitureRecipe parentRecipe, class_1799 output, List<class_1856> ingredients) {
            this.parentRecipe = parentRecipe;
            this.output = output;
            this.ingredients = ingredients;
            this.combinedIngredients = Lists.newArrayList();
            this.combinedIngredients.addAll(ingredients);
            this.combinedIngredients.addAll(parentRecipe.ingredients.vanillaIngredients);
            parentRecipe.outputToInnerRecipe.put(output, this);
            parentRecipe.outputItemToInnerRecipe.put(output.method_7909(), this);
        }

        @Override
        public class_1799 getResult(class_7225.class_7874 registryManager) {
            return this.output;
        }

        @Override
        public List<class_1856> getIngredients() {
            return this.combinedIngredients;
        }

        @Override
        public boolean matches(FurnitureRecipe.FurnitureRecipeInput inventory, class_1937 world) {
            Map<class_1792, Integer> ingredientCounts = this.getItemCounts();
            for (Map.Entry<class_1792, Integer> entry : ingredientCounts.entrySet()) {
                class_1792 item = entry.getKey();
                Integer count = entry.getValue();
                int itemCount = 0;
                class_1799 defaultStack = item.method_7854();
                for (class_1799 stack1 : inventory.playerInventory().method_67533()) {
                    if (!defaultStack.method_31574(stack1.method_7909())) continue;
                    itemCount += stack1.method_7947();
                }
                if (itemCount >= count) continue;
                return false;
            }
            return true;
        }

        @Override
        public FurnitureRecipe parent() {
            return this.parentRecipe;
        }

        @Override
        public class_1799 craft(FurnitureRecipe.FurnitureRecipeInput inventory, class_7225.class_7874 registryManager) {
            return this.output.method_7972();
        }

        @Override
        public class_1799 getRecipeOuput() {
            return this.output;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FurnitureInnerRecipe)) {
                return false;
            }
            FurnitureInnerRecipe that = (FurnitureInnerRecipe)object;
            return Objects.equals(this.parentRecipe, that.parentRecipe) && class_1799.method_7973((class_1799)this.output, (class_1799)that.output) && Objects.equals(this.combinedIngredients, that.combinedIngredients);
        }

        public int hashCode() {
            return Objects.hash(this.parentRecipe, this.output, this.combinedIngredients);
        }
    }

    public static class Serializer
    implements class_1865<DynamicFurnitureRecipe> {
        MapCodec<DynamicFurnitureRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1860::method_8112), (App)FurnitureOutput.CODEC.fieldOf("result").forGetter(DynamicFurnitureRecipe::getOutput), (App)class_2960.field_25139.listOf().fieldOf("supportedVariants").forGetter(DynamicFurnitureRecipe::getSupportedVariants), (App)FurnitureIngredients.CODEC.fieldOf("ingredients").forGetter(DynamicFurnitureRecipe::getInnerIngredients)).apply((Applicative)instance, DynamicFurnitureRecipe::new));
        public static final class_9139<class_9129, DynamicFurnitureRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<DynamicFurnitureRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, DynamicFurnitureRecipe> method_56104() {
            return PACKET_CODEC;
        }

        public static DynamicFurnitureRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            List supportedVariants = buf.method_34066(class_2540::method_10810);
            FurnitureIngredients ingredients = FurnitureIngredients.read(buf);
            FurnitureOutput output = FurnitureOutput.read(buf);
            return new DynamicFurnitureRecipe(group, output, supportedVariants, ingredients);
        }

        public static void write(class_9129 buf, DynamicFurnitureRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_34062(recipe.supportedVariants, class_2540::method_10812);
            FurnitureIngredients.write(buf, recipe.ingredients);
            FurnitureOutput.write(buf, recipe.furnitureOutput);
        }
    }
}

