/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.config.LightSourceSettingEntry;
import dev.lambdaurora.lambdynlights.engine.lookup.SpatialLookupEntry;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class DynamicLightingEngine {
    public static final double MAX_RADIUS = 7.75;
    public static final double MAX_RADIUS_SQUARED = 60.0625;
    public static final int CELL_SIZE = class_3532.method_15384((double)7.75);
    public static final int MAX_LIGHT_SOURCES = 4096;
    private static final class_2382[] CELL_OFFSETS = new class_2382[27];
    private final SpatialLookupEntry[] spatialLookupEntries = new SpatialLookupEntry[4096];
    private final int[] startIndices = new int[4096];
    private final long[] computeSpatialLookupTimes = new long[40];
    private int lastEntryCount = 0;
    private final DynamicLightsConfig config;

    public DynamicLightingEngine(DynamicLightsConfig config) {
        this.config = config;
    }

    public static <T extends class_1297> boolean canLightUp(T entity) {
        if (entity == class_310.method_1551().field_1724 ? (Boolean)LambDynLights.get().config.getSelfLightSource().get() == false : (Boolean)LambDynLights.get().config.getEntitiesLightSource().get() == false) {
            return false;
        }
        LightSourceSettingEntry setting = DynamicLightHandlerHolder.cast(entity.method_5864()).lambdynlights$getSetting();
        return setting != null && (Boolean)setting.get() != false;
    }

    public double getDynamicLightLevel(@NotNull class_2338 pos) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return 0.0;
        }
        double result = 0.0;
        class_2338.class_2339 currentCell = new class_2338.class_2339(DynamicLightingEngine.positionToCell(pos.method_10263()), DynamicLightingEngine.positionToCell(pos.method_10264()), DynamicLightingEngine.positionToCell(pos.method_10260()));
        class_2338 cell = currentCell.method_10062();
        for (class_2382 cellOffset : CELL_OFFSETS) {
            int startIndex;
            SpatialLookupEntry entry;
            currentCell.method_35831((class_2382)cell, cellOffset);
            int key = DynamicLightingEngine.hashCell(currentCell.method_10263(), currentCell.method_10264(), currentCell.method_10260());
            for (int i = startIndex = this.startIndices[key]; i < this.spatialLookupEntries.length && (entry = this.spatialLookupEntries[i]) != null && entry.cellKey() == key; ++i) {
                double light = entry.getDynamicLightLevel(pos);
                if (!(light > result)) continue;
                result = light;
            }
        }
        return class_3532.method_15350((double)result, (double)0.0, (double)15.0);
    }

    public float getComputeSpatialLookupTime() {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return 0.0f;
        }
        return (float)Arrays.stream(this.computeSpatialLookupTimes).filter(value -> value > 0L).average().orElse(0.0);
    }

    public static int hashAt(int x, int y, int z) {
        return DynamicLightingEngine.hashCell(DynamicLightingEngine.positionToCell(x), DynamicLightingEngine.positionToCell(y), DynamicLightingEngine.positionToCell(z));
    }

    public static int positionToCell(int coordinate) {
        return coordinate >> 3;
    }

    public static int hashCell(int cellX, int cellY, int cellZ) {
        return Math.abs(((cellX + 31) * 19 + cellY) * 41 + cellZ) * 83 & 0xFFF;
    }

    public void computeSpatialLookup(Collection<? extends DynamicLightSource> lightSources) {
        long startTime = System.nanoTime();
        Arrays.fill(this.spatialLookupEntries, null);
        Arrays.fill(this.startIndices, Integer.MAX_VALUE);
        Iterator it = lightSources.stream().flatMap(DynamicLightSource::splitIntoDynamicLightEntries).limit(4096L).sorted(Comparator.comparingInt(SpatialLookupEntry::cellKey)).iterator();
        int i = 0;
        while (it.hasNext()) {
            SpatialLookupEntry entry;
            this.spatialLookupEntries[i] = entry = (SpatialLookupEntry)it.next();
            ++i;
        }
        for (i = 0; i < 4096; ++i) {
            int previousKey;
            if (this.spatialLookupEntries[i] == null) {
                this.lastEntryCount = i;
                break;
            }
            int key = this.spatialLookupEntries[i].cellKey();
            int n = previousKey = i == 0 ? Integer.MAX_VALUE : this.spatialLookupEntries[i - 1].cellKey();
            if (key == previousKey) continue;
            this.startIndices[key] = i;
        }
        long endTime = System.nanoTime();
        for (i = 0; i < this.computeSpatialLookupTimes.length - 1; ++i) {
            this.computeSpatialLookupTimes[i] = this.computeSpatialLookupTimes[i + 1];
        }
        this.computeSpatialLookupTimes[this.computeSpatialLookupTimes.length - 1] = endTime - startTime;
    }

    @VisibleForTesting
    public boolean hasEntriesAt(int cellX, int cellY, int cellZ) {
        int key = DynamicLightingEngine.hashCell(cellX, cellY, cellZ);
        return this.startIndices[key] < 4096;
    }

    @VisibleForTesting
    public int getEntryCountAt(int cellX, int cellY, int cellZ) {
        SpatialLookupEntry entry;
        int key = DynamicLightingEngine.hashCell(cellX, cellY, cellZ);
        int startIndex = this.startIndices[key];
        int count = 0;
        for (int i = startIndex; i < this.spatialLookupEntries.length && (entry = this.spatialLookupEntries[i]) != null && entry.cellKey() == key; ++i) {
            ++count;
        }
        return count;
    }

    @VisibleForTesting
    public int getLastEntryCount() {
        return this.lastEntryCount;
    }

    static {
        int i = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    DynamicLightingEngine.CELL_OFFSETS[i] = new class_2382(x, y, z);
                    ++i;
                }
            }
        }
    }
}

