/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.behavior.BathtubBehavior;
import com.unlikepaladin.pfm.blocks.blockentities.BathtubBlockEntity;
import com.unlikepaladin.pfm.entity.ChairEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Entities;
import com.unlikepaladin.pfm.registry.ParticleIDs;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BasicBathtubBlock
extends class_2244 {
    public static final class_2758 LEVEL_8 = class_2758.method_11867((String)"level", (int)0, (int)8);
    private final Map<class_1792, BathtubBehavior> behaviorMap;
    private final class_1959.class_1963 precipitation;
    private static final List<BasicBathtubBlock> basicBathtubBlocks = new ArrayList<BasicBathtubBlock>();
    public float height;
    private static final class_265 FOOT = class_259.method_1072((class_265)BasicBathtubBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), (class_265)BasicBathtubBlock.method_9541((double)0.0, (double)2.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), (class_247)class_247.field_16886);
    private static final class_265 FOOT_NORTH = SimpleStoolBlock.rotateShape(class_2350.field_11039, class_2350.field_11043, FOOT);
    private static final class_265 FOOT_EAST = SimpleStoolBlock.rotateShape(class_2350.field_11039, class_2350.field_11034, FOOT);
    private static final class_265 FOOT_SOUTH = SimpleStoolBlock.rotateShape(class_2350.field_11039, class_2350.field_11035, FOOT);
    public static final MapCodec<BasicBathtubBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BasicBathtubBlock.method_54096(), (App)BathtubBehavior.CODEC.fieldOf("behaviorMap").forGetter(basicBathtubBlock -> basicBathtubBlock.behaviorMap), (App)class_1959.class_1963.field_46251.fieldOf("precipitation").forGetter(basicBathtubBlock -> basicBathtubBlock.precipitation)).apply((Applicative)instance, BasicBathtubBlock::new));

    public BasicBathtubBlock(class_4970.class_2251 settings, Map<class_1792, BathtubBehavior> map, class_1959.class_1963 precipitation) {
        super(class_1767.field_7952, settings.method_9631(state -> 0).method_26249((blockstate, b, c) -> false));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)LEVEL_8, (Comparable)Integer.valueOf(0))).method_11657((class_2769)field_9967, (Comparable)class_2742.field_12557)).method_11657((class_2769)field_9968, (Comparable)Boolean.valueOf(false)));
        this.behaviorMap = map;
        this.precipitation = precipitation;
        this.height = 0.05f;
        basicBathtubBlocks.add(this);
    }

    public static Stream<BasicBathtubBlock> basicBathtubBlockStream() {
        return basicBathtubBlocks.stream();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{LEVEL_8});
        super.method_9515(stateManager);
    }

    protected void onFireCollision(class_2680 state, class_1937 world, class_2338 pos) {
        BasicBathtubBlock.decrementFluidLevel(state, world, pos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        if (state.method_11654((class_2769)field_9967) == class_2742.field_12560) {
            direction = direction.method_10153();
        }
        return world.method_8320(pos.method_10093(direction)).method_26215() || world.method_8320(pos.method_10093(direction)).method_26204() == this;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!world.field_9236) {
            world.method_8652(pos.method_10093((class_2350)state.method_11654((class_2769)field_11177)), (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)((class_2350)state.method_11654((class_2769)field_11177)))).method_11657((class_2769)field_9967, (Comparable)class_2742.field_12560), 3);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        entity.method_18799(entity.method_18798().method_18805(1.0, 0.0, 1.0));
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        class_2742 bedPart;
        if (!world.field_9236 && player.method_68878() && (bedPart = (class_2742)state.method_11654((class_2769)field_9967)) == class_2742.field_12557 && (blockState = world.method_8320(blockPos = pos.method_10093(BasicBathtubBlock.getDirectionTowardsOtherPart(bedPart, (class_2350)state.method_11654((class_2769)field_11177))))).method_26204() == this && blockState.method_11654((class_2769)field_9967) == class_2742.field_12560) {
            world.method_8652(blockPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444((class_1297)player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        int i = (Integer)state.method_11654((class_2769)LEVEL_8);
        if (!world.field_9236 && entity.method_5809() && i != 0) {
            entity.method_5646();
            this.onFireCollision(state, world, pos);
        }
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)LEVEL_8);
    }

    protected static boolean canFillWithPrecipitation(class_1937 world, class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382) {
            return world.method_8409().method_43057() < 0.05f;
        }
        if (precipitation == class_1959.class_1963.field_9383) {
            return world.method_8409().method_43057() < 0.1f;
        }
        return false;
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        if (!BasicBathtubBlock.canFillWithPrecipitation(world, precipitation) || (Integer)state.method_11654((class_2769)LEVEL_8) == 8 || this.precipitation != precipitation) {
            return;
        }
        world.method_8501(pos, (class_2680)state.method_28493((class_2769)LEVEL_8));
    }

    public static void decrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos) {
        int i = (Integer)state.method_11654((class_2769)LEVEL_8) - 1;
        if (i < 0) {
            i = 0;
        }
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL_8, (Comparable)Integer.valueOf(i)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = PaladinFurnitureMod.getPFMConfig().doChairsFacePlayer() ? ctx.method_8042() : ctx.method_8042().method_10153();
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing);
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2680 sourceState;
        class_2338 sourcePos = pos.method_10074().method_10074();
        class_1799 itemStack = player.method_5998(hand);
        BathtubBehavior sinkBehavior = this.behaviorMap.get(itemStack.method_7909());
        if (sinkBehavior != null && itemStack.method_7909() != class_1802.field_8162) {
            return sinkBehavior.interact(state, world, pos, player, hand, itemStack);
        }
        if ((Integer)state.method_11654((class_2769)LEVEL_8) > 0 && player.method_5715() && player.method_5998(hand).method_7960()) {
            world.method_8396(null, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
            BasicBathtubBlock.decrementFluidLevel(state, world, pos);
            return class_1269.field_5812;
        }
        if ((Integer)state.method_11654((class_2769)LEVEL_8) < 8 && (sourceState = world.method_8320(sourcePos)).method_26227().method_15772() == class_3612.field_15910 && !sourceState.method_26227().method_15769()) {
            BathtubBlockEntity blockEntity;
            if (sourceState.method_28501().contains(class_2741.field_12508)) {
                world.method_8501(sourcePos, (class_2680)sourceState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
            } else {
                world.method_8501(sourcePos, class_2246.field_10124.method_9564());
            }
            class_2338 headPos = pos;
            if (state.method_11654((class_2769)field_9967) != class_2742.field_12560) {
                headPos = headPos.method_10093(BasicBathtubBlock.getDirectionTowardsOtherPart((class_2742)state.method_11654((class_2769)field_9967), (class_2350)state.method_11654((class_2769)field_11177)));
            }
            if ((blockEntity = (BathtubBlockEntity)world.method_8321(headPos)) != null) {
                blockEntity.setFilling(true);
            }
            BathtubBehavior.fillTub(world, pos, player, hand, player.method_5998(hand), state, class_3417.field_15237, false);
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.method_23886() && world.method_8597().comp_648()) {
            super.method_55766(state, world, pos, player, hit);
            return class_1269.field_5812;
        }
        return this.sit(state, world, pos, player, hit);
    }

    public class_1269 sit(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            if (player.method_7325() || player.method_5715()) {
                return class_1269.field_5811;
            }
            double px = (double)pos.method_10263() + 0.5;
            double pz = (double)pos.method_10260() + 0.5;
            double py = (float)pos.method_10264() + this.height;
            List active = world.method_8390(ChairEntity.class, new class_238(pos), class_1297::method_5817);
            if (!active.isEmpty()) {
                return class_1269.field_5811;
            }
            float yaw = ((class_2350)state.method_11654((class_2769)field_11177)).method_10153().method_10144();
            if (state.method_11654((class_2769)field_9967) == class_2742.field_12557) {
                yaw = ((class_2350)state.method_11654((class_2769)field_11177)).method_10144();
            }
            ChairEntity entity = (ChairEntity)Entities.CHAIR.method_5883(world, class_3730.field_16467);
            entity.method_5808(px, py, pz, yaw, 0.0f);
            entity.method_5875(true);
            entity.method_5803(true);
            entity.method_5648(false);
            entity.method_5684(true);
            entity.method_5977(true);
            entity.method_5847(yaw);
            entity.method_5636(yaw);
            if (world.method_8649((class_1297)entity)) {
                player.method_5873((class_1297)entity, true);
                player.method_5847(yaw);
                entity.method_5636(yaw);
                entity.method_5847(yaw);
                player.method_7281(Statistics.USE_BATHTUB);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5812;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2742 tubPart = (class_2742)state.method_11654((class_2769)field_9967);
        if (direction == BasicBathtubBlock.getDirectionTowardsOtherPart(tubPart, (class_2350)state.method_11654((class_2769)field_11177))) {
            if (neighborState.method_27852((class_2248)this) && neighborState.method_11654((class_2769)field_9967) != tubPart) {
                return (class_2680)((class_2680)state.method_11657((class_2769)LEVEL_8, (Comparable)((Integer)neighborState.method_11654((class_2769)LEVEL_8)))).method_11657((class_2769)field_9968, (Comparable)((Boolean)neighborState.method_11654((class_2769)field_9968)));
            }
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    private static class_2350 getDirectionTowardsOtherPart(class_2742 part, class_2350 direction) {
        return part == class_2742.field_12557 ? direction : direction.method_10153();
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        class_2742 part = (class_2742)state.method_11654((class_2769)field_9967);
        if (part == class_2742.field_12557) {
            switch (facing) {
                case field_11039: {
                    return FOOT;
                }
                case field_11034: {
                    return FOOT_EAST;
                }
                case field_11043: {
                    return FOOT_NORTH;
                }
            }
            return FOOT_SOUTH;
        }
        switch (facing) {
            case field_11039: {
                return FOOT_EAST;
            }
            case field_11034: {
                return FOOT;
            }
            case field_11043: {
                return FOOT_SOUTH;
            }
        }
        return FOOT_NORTH;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.BATHTUB_BLOCK_ENTITY, BathtubBlockEntity::tick);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BathtubBlockEntity(pos, state);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public static void spawnParticles(class_2350 facing, class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            if (facing == class_2350.field_11034) {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
            } else if (facing == class_2350.field_11035) {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
            } else if (facing == class_2350.field_11043) {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
            } else {
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.method_8466((class_2394)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public MapCodec<class_2244> method_53969() {
        return CODEC;
    }
}

