/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.runtime.data.PFMRecipeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10809;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_3665;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public abstract class AbstractBakedModel
implements class_1087 {
    private final class_3665 settings;
    private final List<class_10889> templateBakedModels;
    public class_10809 itemDisplaySettings;
    public static boolean reloading = false;
    Map<class_2248, VariantBase<?>> blockVariantMap = new HashMap();
    private final Map<class_1747, class_2680> blockItemBlockStateMap = new HashMap<class_1747, class_2680>();
    private final Map<class_2248, List<class_1058>> spriteList = new HashMap<class_2248, List<class_1058>>();

    public AbstractBakedModel(class_3665 settings, class_10809 itemBakeSettings, List<class_10889> templateBakedModels) {
        this.settings = settings;
        this.templateBakedModels = Objects.requireNonNull(templateBakedModels);
        this.itemDisplaySettings = itemBakeSettings;
    }

    public class_10809 getItemDisplaySettings() {
        return this.itemDisplaySettings;
    }

    public List<class_10889> getTemplateBakedModels() {
        return this.templateBakedModels;
    }

    public List<class_10889> method_68512(class_5819 random) {
        return this.templateBakedModels;
    }

    public void method_68513(class_5819 random, List<class_10889> parts) {
        parts.addAll(this.getTemplateBakedModels());
    }

    public VariantBase<?> getVariant(class_2680 state) {
        VariantBase<?> variant;
        if (this.blockVariantMap.containsKey(state.method_26204())) {
            variant = this.blockVariantMap.get(state.method_26204());
        } else if (state != null && PaladinFurnitureMod.furnitureEntryMap.containsKey(state.method_26204().getClass())) {
            variant = PaladinFurnitureMod.furnitureEntryMap.get(state.method_26204().getClass()).getVariantFromEntry(state.method_26204());
            this.blockVariantMap.put(state.method_26204(), variant);
        } else {
            variant = null;
        }
        return variant;
    }

    public <T> List<class_1058> getSpriteList(T element) {
        List<class_1058> spriteList = this.getSpriteListWrapped(element);
        if (spriteList == null || spriteList.isEmpty() || spriteList.size() < 2) {
            WoodVariant variant = WoodVariantRegistry.OAK;
            class_4730 mainTexture = new class_4730(class_1059.field_5275, ModelHelper.getTextureId(((VariantBase)variant).getBaseBlock()));
            class_4730 secondTexture = new class_4730(class_1059.field_5275, ModelHelper.getTextureId(((VariantBase)variant).getSecondaryBlock()));
            return List.of(mainTexture.method_24148(), secondTexture.method_24148());
        }
        return spriteList;
    }

    public <T> List<class_1058> getSpriteListWrapped(T element) {
        if (element instanceof class_2680) {
            class_2680 state = (class_2680)element;
            return this.getSpriteFromState(state);
        }
        if (element instanceof class_1747) {
            class_1747 blockItem = (class_1747)element;
            if (this.blockItemBlockStateMap.containsKey(blockItem)) {
                return this.getSpriteFromState(this.blockItemBlockStateMap.get(blockItem));
            }
            class_2680 state = blockItem.method_7711().method_9564();
            this.blockItemBlockStateMap.put(blockItem, state);
            return this.getSpriteFromState(state);
        }
        if (element instanceof class_2248) {
            class_2248 block = (class_2248)element;
            if (this.spriteList.containsKey(block)) {
                return this.spriteList.get(block);
            }
            class_2680 state = block.method_9564();
            return this.getSpriteFromState(state);
        }
        if (element instanceof class_1799 && ((class_1799)element).method_7909() instanceof class_1747) {
            class_1747 blockItem = (class_1747)((class_1799)element).method_7909();
            if (this.blockItemBlockStateMap.containsKey(blockItem)) {
                return this.getSpriteFromState(this.blockItemBlockStateMap.get(blockItem));
            }
            class_2680 state = blockItem.method_7711().method_9564();
            this.blockItemBlockStateMap.put(blockItem, state);
            return this.getSpriteFromState(state);
        }
        if (element == null) {
            return Collections.singletonList(this.getTemplateBakedModels().get(0).comp_3752());
        }
        PaladinFurnitureMod.GENERAL_LOGGER.error("Invalid element for sprite list method");
        return Collections.singletonList(this.getTemplateBakedModels().get(0).comp_3752());
    }

    protected List<class_1058> getBedSprites(class_1767 color, class_2680 state) {
        ArrayList<class_1058> list = new ArrayList<class_1058>(3);
        VariantBase<?> variant = this.getVariant(state);
        return list;
    }

    private List<class_1058> getSpriteFromState(class_2680 state) {
        if (this.spriteList.containsKey(state.method_26204())) {
            return this.spriteList.get(state.method_26204());
        }
        VariantBase<?> variant = this.getVariant(state);
        boolean stripped = state.method_26204().method_63499().contains("stripped");
        ArrayList<class_1058> list = new ArrayList<class_1058>(3);
        if (state.method_26204() instanceof SimpleBedBlock) {
            class_1767 color = ModelHelper.getColor(class_7923.field_41175.method_10221((Object)state.method_26204()));
            class_4730 mainTexture = new class_4730(class_1059.field_5275, variant.getTexture(BlockType.PLANKS));
            class_4730 spriteIdentifier = class_4722.method_65527((class_1767)color);
            list.add(mainTexture.method_24148());
            list.add(spriteIdentifier.method_24148());
        } else if (state.method_26204() instanceof LogStoolBlock) {
            mainTexture = stripped ? new class_4730(class_1059.field_5275, variant.getTexture(BlockType.STRIPPED_LOG)) : new class_4730(class_1059.field_5275, variant.getTexture(BlockType.LOG));
            secondTexture = stripped ? new class_4730(class_1059.field_5275, variant.getTexture(BlockType.STRIPPED_LOG_TOP)) : new class_4730(class_1059.field_5275, variant.getTexture(BlockType.LOG_TOP));
            list.add(mainTexture.method_24148());
            list.add(secondTexture.method_24148());
        } else if (!state.method_26204().method_63499().contains("_raw_")) {
            mainTexture = stripped ? new class_4730(class_1059.field_5275, variant.getTexture(BlockType.STRIPPED_LOG)) : new class_4730(class_1059.field_5275, variant.getTexture(BlockType.PRIMARY));
            secondTexture = stripped ? new class_4730(class_1059.field_5275, variant.getTexture(BlockType.PRIMARY)) : new class_4730(class_1059.field_5275, variant.getTexture(BlockType.SECONDARY));
            list.add(mainTexture.method_24148());
            list.add(secondTexture.method_24148());
        } else {
            mainTexture = stripped ? new class_4730(class_1059.field_5275, variant.getTexture(BlockType.STRIPPED_LOG)) : new class_4730(class_1059.field_5275, variant.getTexture(BlockType.SECONDARY));
            list.add(mainTexture.method_24148());
            list.add(mainTexture.method_24148());
        }
        boolean isKitchen = state.method_26204().method_63499().contains("kitchen_");
        if (isKitchen && !(variant instanceof WoodVariant)) {
            class_3545<class_2248, class_2248> counterMaterials = PFMRecipeProvider.getCounterMaterials(variant);
            class_4730 mainTexture = new class_4730(class_1059.field_5275, ModelHelper.getTextureId((class_2248)counterMaterials.method_15442()));
            class_4730 secondTexture = new class_4730(class_1059.field_5275, ModelHelper.getTextureId((class_2248)counterMaterials.method_15441()));
            list.set(0, mainTexture.method_24148());
            list.set(1, secondTexture.method_24148());
        }
        this.spriteList.put(state.method_26204(), list);
        return list;
    }
}

