/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.screens;

import com.unlikepaladin.pfm.menus.WorkbenchScreenHandler;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1124;
import net.minecraft.class_1129;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_465;
import net.minecraft.class_634;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class WorkbenchScreen
extends class_465<WorkbenchScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60654((String)"pfm:textures/gui/container/working_table.png");
    private static final int SCROLLBAR_WIDTH = 12;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int RECIPE_LIST_COLUMNS = 6;
    private static final int RECIPE_LIST_ROWS = 3;
    private static final int RECIPE_ENTRY_WIDTH = 16;
    private static final int RECIPE_ENTRY_HEIGHT = 18;
    private static final int SCROLLBAR_AREA_HEIGHT = 54;
    private static final int RECIPE_LIST_OFFSET_X = 20;
    private static final int RECIPE_LIST_OFFSET_Y = 30;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;
    private boolean canCraft;
    private class_342 searchBox;
    private final Set<class_6862<class_1792>> searchResultTags = new HashSet<class_6862<class_1792>>();

    public WorkbenchScreen(WorkbenchScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        this.canCraft = handler.canCraft();
    }

    protected void method_25426() {
        super.method_25426();
        Objects.requireNonNull(this.field_22793);
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 20, this.field_2800 + 18, 110, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.searchBox);
        this.field_2779 = 180;
        this.field_2792 = 176;
        this.field_25270 = this.field_2779 - 92;
    }

    public void method_25410(class_310 client, int width, int height) {
        String string = this.searchBox.method_1882();
        this.method_25423(client, width, height);
        this.searchBox.method_1852(string);
        if (!this.searchBox.method_1882().isEmpty()) {
            this.search();
        }
    }

    public boolean method_25400(char chr, int modifiers) {
        String string = this.searchBox.method_1882();
        if (this.searchBox.method_25400(chr, modifiers)) {
            if (!Objects.equals(string, this.searchBox.method_1882())) {
                this.search();
            }
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean bl2 = class_3675.method_15985((int)keyCode, (int)scanCode).method_30103().isPresent();
        if (bl2 && this.method_2384(keyCode, scanCode)) {
            return true;
        }
        String string = this.searchBox.method_1882();
        if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(string, this.searchBox.method_1882())) {
                this.search();
            }
            return true;
        }
        if (this.searchBox.method_25370() && this.searchBox.method_1885() && keyCode != 256) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void search() {
        ((WorkbenchScreenHandler)this.field_2797).getSearchableRecipes().clear();
        this.searchResultTags.clear();
        String string = this.searchBox.method_1882();
        if (string.isEmpty()) {
            ((WorkbenchScreenHandler)this.field_2797).updateInput();
            ((WorkbenchScreenHandler)this.field_2797).searching = false;
        } else {
            ((WorkbenchScreenHandler)this.field_2797).updateInput();
            class_634 clientPlayNetworkHandler = this.field_22787.method_1562();
            if (clientPlayNetworkHandler != null) {
                class_1129 searchable;
                class_1124 searchManager = clientPlayNetworkHandler.method_60347();
                if (string.startsWith("#")) {
                    string = string.substring(1);
                    searchable = searchManager.method_60370();
                    this.searchForTags(string);
                } else {
                    searchable = searchManager.method_60372();
                }
                ArrayList items = new ArrayList();
                searchable.method_4810(string.toLowerCase(Locale.ROOT)).forEach(itemStack -> items.add(itemStack.method_7909()));
                ((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().forEach(furnitureRecipe -> {
                    if (items.contains(furnitureRecipe.getRecipeOuput().method_7909())) {
                        ((WorkbenchScreenHandler)this.field_2797).getSearchableRecipes().add((FurnitureRecipe.CraftableFurnitureRecipe)furnitureRecipe);
                    }
                });
                ((WorkbenchScreenHandler)this.field_2797).searching = true;
            }
        }
        this.scrollAmount = 0.0f;
        this.scrollOffset = 0;
    }

    private void searchForTags(String id) {
        Predicate<class_2960> predicate;
        int i = id.indexOf(58);
        if (i == -1) {
            predicate = idx -> idx.method_12832().contains(id);
        } else {
            String string = id.substring(0, i).trim();
            String string2 = id.substring(i + 1).trim();
            predicate = idx -> idx.method_12836().contains(string) && idx.method_12832().contains(string2);
        }
        Stream<class_6862> keyStream = class_7923.field_41178.method_40272().filter(tagKey -> predicate.test(tagKey.method_40251().comp_327())).map(class_6885.class_6888::method_40251);
        keyStream.forEach(this.searchResultTags::add);
    }

    public void method_37432() {
        super.method_37432();
        if (this.searchBox != null) {
            // empty if block
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int x = this.field_2776;
        int y = this.field_2800;
        context.method_25290(class_1921::method_62277, TEXTURE, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        int k = (int)(41.0f * this.scrollAmount);
        context.method_25290(class_1921::method_62277, TEXTURE, x + 119, y + 31 + k, (float)(176 + (this.shouldScroll() ? 0 : 12)), 0.0f, 12, 15, 256, 256);
        int xOffSetForIcons = this.field_2776 + 20;
        int yOffsetForIcons = this.field_2800 + 30;
        int scrollOffsetForIcons = this.scrollOffset + 18;
        this.renderRecipeBackground(context, mouseX, mouseY, xOffSetForIcons, yOffsetForIcons, scrollOffsetForIcons);
        this.renderRecipeIcons(context, xOffSetForIcons, yOffsetForIcons, scrollOffsetForIcons);
        this.searchBox.method_25394(context, mouseX, mouseY, delta);
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        int xOffsetForTooltip = this.field_2776 + 20;
        int yOffsetForTooltip = this.field_2800 + 30;
        int scrollOffsetForTooltip = this.scrollOffset + 18;
        for (int recipeIndex = this.scrollOffset; recipeIndex < scrollOffsetForTooltip && recipeIndex < ((WorkbenchScreenHandler)this.field_2797).getVisibleRecipeCount(); ++recipeIndex) {
            int m = recipeIndex - this.scrollOffset;
            int n = xOffsetForTooltip + m % 6 * 16;
            int o = yOffsetForTooltip + m / 6 * 18 + 2;
            if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            int iCopy = recipeIndex;
            if (((WorkbenchScreenHandler)this.field_2797).searching) {
                iCopy = ((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.field_2797).getSearchableRecipes().get(iCopy));
            }
            tooltip.add((class_2561)this.method_51454(((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().get(iCopy).getRecipeOuput()).get(0));
            tooltip.add(class_2561.method_43471((String)"container.pfm.working_table.ingredient_required").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
            HashMap<class_1792, Integer> itemStackCountMap = new HashMap<class_1792, Integer>();
            for (class_1856 ingredient : ((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().get(iCopy).getIngredients()) {
                for (class_6880 item2 : ingredient.method_8105().toList()) {
                    if (!itemStackCountMap.containsKey(item2.comp_349())) {
                        itemStackCountMap.put((class_1792)item2.comp_349(), 1);
                        continue;
                    }
                    itemStackCountMap.put((class_1792)item2.comp_349(), (Integer)itemStackCountMap.get(item2.comp_349()) + 1);
                }
            }
            itemStackCountMap.forEach((item, integer) -> {
                int itemCount = ((WorkbenchScreenHandler)this.field_2797).getPlayerInventory().method_18861(item);
                class_2583 style = class_2583.field_24360.method_10977(class_124.field_1080);
                if (itemCount < integer) {
                    style = style.method_10977(class_124.field_1061);
                }
                tooltip.add(class_2561.method_43470((String)(integer + " ")).method_10852((class_2561)class_2561.method_43470((String)((class_2561)this.method_51454(item.method_7854()).get(0)).getString())).method_10862(style));
            });
            context.method_51434(this.field_22793, tooltip, x, y);
        }
    }

    private void renderRecipeBackground(class_332 context, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((WorkbenchScreenHandler)this.field_2797).getVisibleRecipeCount(); ++i) {
            int j = i - this.scrollOffset;
            int k = x + j % 6 * 16;
            int l = j / 6;
            int m = y + l * 18 + 2;
            int v = this.field_2779;
            int iCopy = i;
            if (((WorkbenchScreenHandler)this.field_2797).searching) {
                iCopy = ((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.field_2797).getSearchableRecipes().get(iCopy));
            }
            if (iCopy == ((WorkbenchScreenHandler)this.field_2797).getSelectedRecipe()) {
                v += 55;
            } else if (!((WorkbenchScreenHandler)this.field_2797).getAvailableRecipes().contains(((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().get(iCopy))) {
                v += 18;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                v += 36;
            }
            context.method_25290(class_1921::method_62277, TEXTURE, k, m - 1, 0.0f, (float)v, 16, 18, 256, 256);
        }
    }

    private void renderRecipeIcons(class_332 context, int x, int y, int scrollOffset) {
        for (int i = this.scrollOffset; i < scrollOffset && i < ((WorkbenchScreenHandler)this.field_2797).getVisibleRecipeCount(); ++i) {
            int iMinusScrollOffset = i - this.scrollOffset;
            int xOffset = x + iMinusScrollOffset % 6 * 16;
            int l = iMinusScrollOffset / 6;
            int yOffset = y + l * 18 + 2;
            int iCopy = i;
            if (((WorkbenchScreenHandler)this.field_2797).searching) {
                iCopy = ((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.field_2797).getSearchableRecipes().get(iCopy));
            }
            context.method_51427(((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().get(iCopy).getRecipeOuput(), xOffset, yOffset);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int xOffsetForMouseClick = this.field_2776 + 20;
            int yOffsetForMouseClick = this.field_2800 + 30;
            int scrollOffsetForMouseClick = this.scrollOffset + 18;
            for (int clickedRecipeId = this.scrollOffset; clickedRecipeId < scrollOffsetForMouseClick; ++clickedRecipeId) {
                int m = clickedRecipeId - this.scrollOffset;
                double d = mouseX - (double)(xOffsetForMouseClick + m % 6 * 16);
                double e = mouseY - (double)(yOffsetForMouseClick + m / 6 * 18);
                int clickedRecipeIdCopy = clickedRecipeId;
                if (((WorkbenchScreenHandler)this.field_2797).searching) {
                    clickedRecipeIdCopy = clickedRecipeIdCopy < ((WorkbenchScreenHandler)this.field_2797).getSearchableRecipes().size() ? ((WorkbenchScreenHandler)this.field_2797).getSortedRecipes().indexOf(((WorkbenchScreenHandler)this.field_2797).getSearchableRecipes().get(clickedRecipeIdCopy)) : -1;
                }
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WorkbenchScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, clickedRecipeIdCopy))) continue;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                this.field_22787.field_1761.method_2900(((WorkbenchScreenHandler)this.field_2797).field_7763, clickedRecipeIdCopy);
                return true;
            }
            xOffsetForMouseClick = this.field_2776 + 119;
            yOffsetForMouseClick = this.field_2800 + 9;
            if (mouseX >= (double)xOffsetForMouseClick && mouseX < (double)(xOffsetForMouseClick + 12) && mouseY >= (double)yOffsetForMouseClick && mouseY < (double)(yOffsetForMouseClick + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 30;
            int j = i + 54;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 6;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            this.scrollAmount = (float)((double)this.scrollAmount - verticalAmount / (double)i);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 6;
        }
        return true;
    }

    private boolean shouldScroll() {
        return ((WorkbenchScreenHandler)this.field_2797).getVisibleRecipeCount() > 18;
    }

    protected int getMaxScroll() {
        return (((WorkbenchScreenHandler)this.field_2797).getVisibleRecipeCount() + 6 - 1) / 6 - 3;
    }

    private void onInventoryChange() {
        this.canCraft = ((WorkbenchScreenHandler)this.field_2797).canCraft();
        if (!this.canCraft) {
            this.scrollAmount = 0.0f;
            this.scrollOffset = 0;
        }
    }
}

