/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.fabric;

import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.compat.cookingforblockheads.fabric.menu.StoveScreenHandlerBalm;
import com.unlikepaladin.pfm.menus.StoveScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.DefaultEnergyStorage;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.tag.BalmItemTags;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProcessor;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.KitchenOperation;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.entity.IMutableNameable;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProcessorHolder;
import net.blay09.mods.cookingforblockheads.capability.KitchenItemProviderHolder;
import net.blay09.mods.cookingforblockheads.kitchen.ContainerKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntityBalm
extends BalmBlockEntity
implements KitchenItemProcessor,
BalmMenuProvider<StoveScreenHandler.StoveData>,
IMutableNameable,
BalmContainerProvider,
BalmEnergyStorageProvider,
KitchenItemProcessorHolder,
KitchenItemProviderHolder {
    private static final int COOK_TIME = 200;
    private final DefaultContainer container = new DefaultContainer(20){

        public boolean method_5437(int slot, class_1799 itemStack) {
            if (slot < 3) {
                return !StoveBlockEntityBalm.this.getSmeltingResult(itemStack).method_7960();
            }
            return slot != 3 || StoveBlockEntityBalm.isItemFuel(StoveBlockEntityBalm.this.field_11863, itemStack);
        }

        public void slotChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                StoveBlockEntityBalm.this.slotCookTime[slot - 7] = 0;
            }
            StoveBlockEntityBalm.this.isDirty = true;
            StoveBlockEntityBalm.this.method_5431();
        }
    };
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int id) {
            if (id == 0) {
                return StoveBlockEntityBalm.this.furnaceBurnTime;
            }
            if (id == 1) {
                return StoveBlockEntityBalm.this.currentItemBurnTime;
            }
            return id >= 2 && id <= 11 ? StoveBlockEntityBalm.this.slotCookTime[id - 2] : 0;
        }

        public void method_17391(int id, int value) {
            if (id == 0) {
                StoveBlockEntityBalm.this.furnaceBurnTime = value;
            } else if (id == 1) {
                StoveBlockEntityBalm.this.currentItemBurnTime = value;
            } else if (id >= 2 && id <= 11) {
                StoveBlockEntityBalm.this.slotCookTime[id - 2] = value;
            }
        }

        public int method_17389() {
            return 11;
        }
    };
    private final EnergyStorage energyStorage = new DefaultEnergyStorage(10000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                StoveBlockEntityBalm.this.method_5431();
            }
            return super.fill(maxReceive, simulate);
        }

        public int drain(int maxExtract, boolean simulate) {
            if (!simulate) {
                StoveBlockEntityBalm.this.method_5431();
            }
            return super.drain(maxExtract, simulate);
        }
    };
    private final SubContainer inputContainer = new SubContainer((class_1263)this.container, 0, 3);
    private final SubContainer fuelContainer = new SubContainer((class_1263)this.container, 3, 4);
    final SubContainer outputContainer = new SubContainer((class_1263)this.container, 4, 7);
    private final SubContainer processingContainer = new SubContainer((class_1263)this.container, 7, 16);
    final SubContainer toolsContainer = new SubContainer((class_1263)this.container, 16, 20);
    private class_2561 customName;
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private class_2350 facing;
    private final class_1263 singleSlotRecipeWrapper = new DefaultContainer(1);
    private KitchenItemProvider itemProvider = new ContainerKitchenItemProvider((class_1263)new CombinedContainer(new class_1263[]{this.toolsContainer, this.outputContainer}));

    public StoveBlockEntityBalm(class_2338 pos, class_2680 state) {
        super(BlockEntities.STOVE_BLOCK_ENTITY, pos, state);
    }

    public boolean method_11004(int id, int type) {
        return super.method_11004(id, type);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (blockEntity instanceof StoveBlockEntityBalm) {
            StoveBlockEntityBalm stoveBlockEntityBalm = (StoveBlockEntityBalm)blockEntity;
            stoveBlockEntityBalm.clientTick(level, pos, state);
        }
    }

    public void clientTick(class_1937 level, class_2338 pos, class_2680 state) {
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (blockEntity instanceof StoveBlockEntityBalm) {
            StoveBlockEntityBalm stoveBlockEntityBalm = (StoveBlockEntityBalm)blockEntity;
            stoveBlockEntityBalm.serverTick(level, pos, state);
        }
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (this.isFirstTick && state.method_26204() instanceof StoveBlock) {
            this.facing = (class_2350)state.method_11654((class_2769)StoveBlock.field_11104);
            this.isFirstTick = false;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.drain(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!level.field_9236) {
            class_1799 itemStack;
            int i;
            class_1799 containerItem;
            int firstEmptySlot;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (firstEmptySlot = 0; firstEmptySlot < this.fuelContainer.method_5439(); ++firstEmptySlot) {
                    class_1799 fuelItem = this.fuelContainer.method_5438(firstEmptySlot);
                    if (fuelItem.method_7960()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)StoveBlockEntityBalm.getBurnTime(level, fuelItem) * CookingForBlockheadsConfig.getActive().ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    containerItem = Balm.getHooks().getCraftingRemainingItem(fuelItem);
                    fuelItem.method_7934(1);
                    if (fuelItem.method_7960()) {
                        this.fuelContainer.method_5447(firstEmptySlot, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (i = 0; i < this.processingContainer.method_5439(); ++i) {
                itemStack = this.processingContainer.method_5438(i);
                if (!itemStack.method_7960()) {
                    if (this.slotCookTime[i] != -1) {
                        class_1799 smeltingResult;
                        double maxCookTime = 200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier;
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).method_7960()) continue;
                        class_1799 resultStack = smeltingResult.method_7972();
                        this.processingContainer.method_5447(i, resultStack);
                        Balm.getEvents().fireEvent((Object)new OvenCookedEvent(level, this.field_11867, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                containerItem = this.processingContainer.method_5438(firstTransferSlot);
                containerItem = ContainerUtils.insertItemStacked((class_1263)this.outputContainer, (class_1799)containerItem, (boolean)false);
                this.processingContainer.method_5447(firstTransferSlot, containerItem);
                if (containerItem.method_7960()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (i = 0; i < this.inputContainer.method_5439(); ++i) {
                    itemStack = this.inputContainer.method_5438(i);
                    if (itemStack.method_7960()) continue;
                    this.processingContainer.method_5447(firstEmptySlot, itemStack.method_7971(1));
                    if (itemStack.method_7947() > 0) break;
                    this.inputContainer.method_5447(i, class_1799.field_8037);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.method_5431();
        }
    }

    public class_1799 getSmeltingResult(class_1799 itemStack) {
        class_9696 recipeInput = new class_9696(itemStack);
        class_1799 ovenRecipeResult = this.getSmeltingResult(ModRecipes.ovenRecipeType, recipeInput);
        return !ovenRecipeResult.method_7960() ? ovenRecipeResult : this.getSmeltingResult(class_3956.field_17546, recipeInput);
    }

    public <T extends class_9695> class_1799 getSmeltingResult(class_3956<? extends class_1860<T>> recipeType, T recipeInput) {
        class_1799 result;
        class_8786 recipe;
        MinecraftServer server = this.field_11863.method_8503();
        if (server != null && (recipe = (class_8786)server.method_3772().method_8132(recipeType, recipeInput, this.field_11863).orElse(null)) != null && !(result = recipe.comp_1933().method_8116(recipeInput, (class_7225.class_7874)this.field_11863.method_30349())).method_7960() && result.method_58694(class_9334.field_50075) != null) {
            return result;
        }
        return class_1799.field_8037;
    }

    public static boolean isItemFuel(class_1937 world, class_1799 itemStack) {
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil) {
            return itemStack.method_31573(BalmItemTags.COOKING_OIL);
        }
        return StoveBlockEntityBalm.getBurnTime(world, itemStack) > 0;
    }

    protected static int getBurnTime(class_1937 world, class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return 0;
        }
        return CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil && itemStack.method_31573(BalmItemTags.COOKING_OIL) ? 800 : 800;
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.processingContainer.method_5439(); ++i) {
            class_1799 cookingStack = this.processingContainer.method_5438(i);
            if (cookingStack.method_7960() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    protected void method_11014(class_2487 tagCompound, class_7225.class_7874 registryLookup) {
        super.method_11014(tagCompound, registryLookup);
        this.container.deserialize(tagCompound.method_10562("ItemHandler").orElse(new class_2487()), registryLookup);
        this.furnaceBurnTime = tagCompound.method_10568("BurnTime").orElse((short)0).shortValue();
        this.currentItemBurnTime = tagCompound.method_10568("CurrentItemBurnTime").orElse((short)0).shortValue();
        this.slotCookTime = tagCompound.method_10561("CookTimes").orElse(new int[0]);
        if (this.slotCookTime.length != 9) {
            this.slotCookTime = new int[9];
        }
        this.hasPowerUpgrade = tagCompound.method_10577("HasPowerUpgrade").orElse(false);
        this.energyStorage.setEnergy(tagCompound.method_10550("EnergyStored").orElse(0).intValue());
        if (tagCompound.method_10545("CustomName")) {
            this.customName = class_2561.class_2562.method_10877((String)tagCompound.method_10558("CustomName").orElse(""), (class_7225.class_7874)registryLookup);
        }
    }

    protected void method_11007(class_2487 tagCompound, class_7225.class_7874 registryLookup) {
        super.method_11007(tagCompound, registryLookup);
        tagCompound.method_10566("ItemHandler", (class_2520)this.container.serialize(registryLookup));
        tagCompound.method_10575("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.method_10575("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tagCompound.method_10539("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tagCompound.method_10556("HasPowerUpgrade", this.hasPowerUpgrade);
        tagCompound.method_10569("EnergyStored", this.energyStorage.getEnergy());
        if (this.customName != null) {
            tagCompound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)registryLookup));
        }
    }

    protected void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag, (class_7225.class_7874)this.field_11863.method_30349());
        super.writeUpdateTag(tag);
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        return this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0 ? 1.0f : (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier);
    }

    public class_1799 smeltItem(class_1799 itemStack) {
        return ContainerUtils.insertItemStacked((class_1263)this.inputContainer, (class_1799)itemStack, (boolean)false);
    }

    public class_1799 getToolItem(int i) {
        return this.toolsContainer.method_5438(i);
    }

    public void setToolItem(int i, class_1799 itemStack) {
        this.toolsContainer.method_5447(i, itemStack);
    }

    public class_1263 getContainer(class_2350 side) {
        if (side == null) {
            return this.getContainer();
        }
        return switch (side) {
            case class_2350.field_11036 -> this.inputContainer;
            case class_2350.field_11033 -> this.outputContainer;
            default -> this.fuelContainer;
        };
    }

    public class_1263 getInputContainer() {
        return this.inputContainer;
    }

    public class_1263 getFuelContainer() {
        return this.fuelContainer;
    }

    public class_2350 getFacing() {
        return this.facing == null ? class_2350.field_11043 : this.facing;
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new StoveScreenHandlerBalm(i, playerInventory, this);
    }

    public class_238 balmGetRenderBoundingBox() {
        return new class_238(this.field_11867.method_10069(-1, 0, -1).method_46558(), this.field_11867.method_10069(2, 1, 2).method_46558());
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
        this.method_5431();
    }

    public boolean method_16914() {
        return this.customName != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public class_2561 method_5476() {
        return this.method_5477();
    }

    public class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.cookingforblockheads.oven");
    }

    public class_1263 getContainer() {
        return this.container;
    }

    public class_3913 getContainerData() {
        return this.dataAccess;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Nullable
    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 nbt = super.method_16887(provider);
        nbt.method_10566("ItemHandler", (class_2520)this.container.serialize(provider));
        return nbt;
    }

    protected void onContainerOpen(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26204() instanceof StoveBlock) {
            this.playSound(state, class_3417.field_15082);
            this.setOpen(state, true);
        }
    }

    protected void onContainerClose(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26204() instanceof StoveBlock) {
            this.playSound(state, class_3417.field_15131);
            this.setOpen(state, false);
        }
    }

    void setOpen(class_2680 state, boolean open) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)class_2741.field_12537, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void onClose(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.onContainerClose(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    public void onOpen(class_1657 player) {
        if (!this.field_11865 && !player.method_7325()) {
            this.onContainerOpen(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    void playSound(class_2680 state, class_3414 soundEvent) {
        class_2382 vec3i = ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_62675();
        double d = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double e = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double f = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d, e, f, soundEvent, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    public boolean canProcess(class_3956<?> recipeType) {
        return recipeType == class_3956.field_17546;
    }

    public KitchenOperation processRecipe(class_1860<?> recipe, List<IngredientToken> ingredientTokens) {
        for (IngredientToken ingredientToken : ingredientTokens) {
            class_1799 itemStack = ingredientToken.consume();
            class_1799 restStack = ContainerUtils.insertItemStacked((class_1263)this.inputContainer, (class_1799)itemStack, (boolean)false);
            if (restStack.method_7960()) continue;
            ingredientToken.restore(restStack);
        }
        return KitchenOperation.EMPTY;
    }

    public StoveScreenHandler.StoveData getScreenOpeningData(class_3222 serverPlayerEntity) {
        return new StoveScreenHandler.StoveData(this.field_11867);
    }

    public class_9139<class_9129, StoveScreenHandler.StoveData> getScreenStreamCodec() {
        return StoveScreenHandler.PACKET_CODEC;
    }

    public KitchenItemProcessor getKitchenItemProcessor() {
        return this;
    }

    public KitchenItemProvider getKitchenItemProvider() {
        return this.itemProvider;
    }
}

