/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.BooleanConfigOption;
import com.unlikepaladin.pfm.config.option.Side;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class PaladinFurnitureModConfig {
    private static final String COMMENT = "This file stores configuration options for Paladin's Furniture Mod";
    private final Path propertiesPath;
    private final Path directoryPath;
    public HashMap<String, AbstractConfigOption> options = new LinkedHashMap<String, AbstractConfigOption>();
    public static final String MOD_OPTIONS = "pfm.config.categories.mod_options";
    public static final String GAMEPLAY_OPTIONS = "pfm.config.categories.gameplay_options";
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private BooleanConfigOption checkForUpdates;
    private BooleanConfigOption shaderSolidFix;
    private BooleanConfigOption doChairsFacePlayer;
    private BooleanConfigOption countersOfDifferentMaterialsConnect;
    private BooleanConfigOption differentMirrorsConnect;
    private BooleanConfigOption foodPopsOffStove;
    private BooleanConfigOption tablesOfDifferentMaterialsConnect;
    private BooleanConfigOption enableBook;
    private BooleanConfigOption mobsSitOnChairs;
    private BooleanConfigOption renderImmersivePortalsMirrors;
    private BooleanConfigOption spawnImmersivePortalsMirror;
    private BooleanConfigOption disableGeneratingScreen;

    public PaladinFurnitureModConfig(Path propertiesPath) {
        AbstractConfigOption[] abstractConfigOptionArray = new AbstractConfigOption[12];
        this.checkForUpdates = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.checkForUpdates"), (class_2561)class_2561.method_43471((String)"pfm.option.checkForUpdates.tooltip"), MOD_OPTIONS, true, Side.CLIENT);
        abstractConfigOptionArray[0] = this.checkForUpdates;
        this.shaderSolidFix = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.shaderSolidFix"), (class_2561)class_2561.method_43471((String)"pfm.option.shaderSolidFix.tooltip"), MOD_OPTIONS, false, Side.CLIENT);
        abstractConfigOptionArray[1] = this.shaderSolidFix;
        this.doChairsFacePlayer = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.chairsFacePlayer"), (class_2561)class_2561.method_43471((String)"pfm.option.chairsFacePlayer.tooltip"), GAMEPLAY_OPTIONS, true, Side.SERVER);
        abstractConfigOptionArray[2] = this.doChairsFacePlayer;
        this.foodPopsOffStove = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.foodPopsOffStove"), (class_2561)class_2561.method_43471((String)"pfm.option.foodPopsOffStove.tooltip"), GAMEPLAY_OPTIONS, false, Side.SERVER);
        abstractConfigOptionArray[3] = this.foodPopsOffStove;
        this.countersOfDifferentMaterialsConnect = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.countersOfDifferentMaterialsConnect"), (class_2561)class_2561.method_43471((String)"pfm.option.countersOfDifferentMaterialsConnect.tooltip"), GAMEPLAY_OPTIONS, false, Side.SERVER);
        abstractConfigOptionArray[4] = this.countersOfDifferentMaterialsConnect;
        this.tablesOfDifferentMaterialsConnect = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.tablesOfDifferentMaterialsConnect"), (class_2561)class_2561.method_43471((String)"pfm.option.tablesOfDifferentMaterialsConnect.tooltip"), GAMEPLAY_OPTIONS, false, Side.SERVER);
        abstractConfigOptionArray[5] = this.tablesOfDifferentMaterialsConnect;
        this.differentMirrorsConnect = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.differentMirrorsConnect"), (class_2561)class_2561.method_43471((String)"pfm.option.differentMirrorsConnect.tooltip"), GAMEPLAY_OPTIONS, false, Side.SERVER);
        abstractConfigOptionArray[6] = this.differentMirrorsConnect;
        this.enableBook = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.enableBook"), (class_2561)class_2561.method_43471((String)"pfm.option.enableBook.tooltip"), GAMEPLAY_OPTIONS, true, Side.SERVER);
        abstractConfigOptionArray[7] = this.enableBook;
        this.mobsSitOnChairs = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.mobsSitOnChairs"), (class_2561)class_2561.method_43471((String)"pfm.option.mobsSitOnChairs.tooltip"), GAMEPLAY_OPTIONS, true, Side.SERVER);
        abstractConfigOptionArray[8] = this.mobsSitOnChairs;
        this.renderImmersivePortalsMirrors = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.renderImmersivePortalsMirrors"), (class_2561)class_2561.method_43471((String)"pfm.option.renderImmersivePortalsMirrors.tooltip"), GAMEPLAY_OPTIONS, true, Side.CLIENT);
        abstractConfigOptionArray[9] = this.renderImmersivePortalsMirrors;
        this.spawnImmersivePortalsMirror = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.spawnImmersivePortalsMirror"), (class_2561)class_2561.method_43471((String)"pfm.option.spawnImmersivePortalsMirror.tooltip"), GAMEPLAY_OPTIONS, true, Side.SERVER);
        abstractConfigOptionArray[10] = this.spawnImmersivePortalsMirror;
        this.disableGeneratingScreen = new BooleanConfigOption((class_2561)class_2561.method_43471((String)"pfm.option.disableGeneratingScreen"), (class_2561)class_2561.method_43471((String)"pfm.option.disableGeneratingScreen.tooltip"), MOD_OPTIONS, false, Side.CLIENT);
        abstractConfigOptionArray[11] = this.disableGeneratingScreen;
        this.addOptions(abstractConfigOptionArray);
        this.propertiesPath = propertiesPath.resolve("pfm.json");
        this.directoryPath = propertiesPath;
    }

    private void addOptions(AbstractConfigOption<?> ... args) {
        ArrayList configOptions = new ArrayList(Arrays.asList(args));
        configOptions.sort(Comparator.comparing(config1 -> config1.getCategory().substring(22).replace("_options", "")));
        Collections.reverse(configOptions);
        for (AbstractConfigOption<?> configOption : configOptions) {
            this.options.put(((class_2588)configOption.getTitle().method_10851()).method_11022(), configOption);
        }
    }

    public void initialize() throws IOException {
        this.load();
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            this.save();
        }
    }

    public boolean doTablesOfDifferentMaterialsConnect() {
        return this.tablesOfDifferentMaterialsConnect.getValue();
    }

    public boolean doDifferentMirrorsConnect() {
        return this.differentMirrorsConnect.getValue();
    }

    public boolean doChairsFacePlayer() {
        return this.doChairsFacePlayer.getValue();
    }

    public boolean doCountersOfDifferentMaterialsConnect() {
        return this.countersOfDifferentMaterialsConnect.getValue();
    }

    public boolean doesFoodPopOffStove() {
        return this.foodPopsOffStove.getValue();
    }

    public boolean shouldCheckForUpdates() {
        return this.checkForUpdates.getValue();
    }

    public boolean shouldGiveGuideBook() {
        return this.enableBook.getValue();
    }

    public boolean doMobsSitOnChairs() {
        return this.mobsSitOnChairs.getValue();
    }

    public boolean isShaderSolidFixOn() {
        return this.shaderSolidFix.getValue();
    }

    public boolean doImmersivePortalsMirrorsRender() {
        return this.renderImmersivePortalsMirrors.getValue();
    }

    public boolean doImmersivePortalsMirrorsSpawn() {
        return this.spawnImmersivePortalsMirror.getValue();
    }

    public boolean disableGeneratingScreen() {
        return this.disableGeneratingScreen.getValue();
    }

    public Path getPath() {
        return this.propertiesPath;
    }

    public void load() throws IOException {
        Path legacyConfig = this.directoryPath.resolve("pfm.properties");
        if (Files.exists(legacyConfig, new LinkOption[0])) {
            this.loadLegacyProperties(legacyConfig);
        }
        if (!Files.exists(this.propertiesPath, new LinkOption[0])) {
            return;
        }
        JsonObject config = new JsonObject();
        try (FileReader reader = new FileReader(this.propertiesPath.toString());){
            JsonElement element = new JsonParser().parse((Reader)reader);
            if (element.isJsonObject()) {
                config = element.getAsJsonObject();
            }
        }
        this.checkForUpdates.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("checkForUpdates"), true));
        this.shaderSolidFix.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("shaderSolidFix"), false));
        this.doChairsFacePlayer.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("chairsFacePlayer"), true));
        this.countersOfDifferentMaterialsConnect.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("countersOfDifferentMaterialsConnect"), false));
        this.tablesOfDifferentMaterialsConnect.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("tablesOfDifferentMaterialsConnect"), false));
        this.foodPopsOffStove.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("foodPopsOffStove"), false));
        this.enableBook.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("enableBook"), false));
        this.differentMirrorsConnect.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("differentMirrorsConnect"), false));
        this.mobsSitOnChairs.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("mobsSitOnChairs"), false));
        this.renderImmersivePortalsMirrors.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("renderImmersivePortalsMirrors"), true));
        this.spawnImmersivePortalsMirror.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("spawnImmersivePortalsMirror"), true));
        this.disableGeneratingScreen.setValue(PaladinFurnitureModConfig.getFromJsonElement(config.get("disableGeneratingScreen"), false));
        for (String key : this.options.keySet()) {
            if (config.has(key.replace("pfm.option.", ""))) continue;
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Missing Config Option: " + key.replace("pfm.option.", "") + ", resetting to default value.");
            this.options.get(key).setValue(this.options.get(key).getDefaultValue());
            this.save();
        }
    }

    public static <T> T getFromJsonElement(JsonElement element, T defaultValue) {
        if (element != null && element.isJsonPrimitive()) {
            Class targetType;
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                targetType = String.class;
            } else if (primitive.isBoolean()) {
                targetType = Boolean.class;
            } else if (primitive.isNumber()) {
                targetType = Number.class;
            } else {
                return null;
            }
            return (T)GSON.fromJson((JsonElement)primitive, targetType);
        }
        return defaultValue;
    }

    public void loadLegacyProperties(Path legacyConfigFile) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(legacyConfigFile, new OpenOption[0]);){
            properties.load(is);
        }
        this.checkForUpdates.setValue("true".equals(properties.getProperty("checkForUpdates")));
        this.shaderSolidFix.setValue(!"false".equals(properties.getProperty("shaderSolidFix")));
        this.doChairsFacePlayer.setValue("true".equals(properties.getProperty("chairsFacePlayer")));
        this.countersOfDifferentMaterialsConnect.setValue(!"false".equals(properties.getProperty("countersOfDifferentMaterialsConnect")));
        this.tablesOfDifferentMaterialsConnect.setValue(!"false".equals(properties.getProperty("tablesOfDifferentMaterialsConnect")));
        this.foodPopsOffStove.setValue(!"false".equals(properties.getProperty("foodPopsOffStove")));
        this.enableBook.setValue("true".equals(properties.getProperty("enableBook")));
        this.differentMirrorsConnect.setValue(!"false".equals(properties.getProperty("differentMirrorsConnect")));
        this.mobsSitOnChairs.setValue("true".equals(properties.getProperty("mobsSitOnChairs")));
        this.renderImmersivePortalsMirrors.setValue("true".equals(properties.getProperty("renderImmersivePortalsMirrors")));
        this.spawnImmersivePortalsMirror.setValue("true".equals(properties.getProperty("spawnImmersivePortalsMirror")));
        this.disableGeneratingScreen.setValue("true".equals(properties.get("disableGeneratingScreen")));
        this.save();
        Files.delete(legacyConfigFile);
        PaladinFurnitureMod.GENERAL_LOGGER.info("Successfully migrated to new config");
    }

    public void save() throws IOException {
        JsonObject object = new JsonObject();
        object.addProperty("checkForUpdates", this.checkForUpdates.getValue());
        object.addProperty("shaderSolidFix", this.shaderSolidFix.getValue());
        object.addProperty("chairsFacePlayer", this.doChairsFacePlayer.getValue());
        object.addProperty("countersOfDifferentMaterialsConnect", this.countersOfDifferentMaterialsConnect.getValue());
        object.addProperty("foodPopsOffStove", this.foodPopsOffStove.getValue());
        object.addProperty("tablesOfDifferentMaterialsConnect", this.tablesOfDifferentMaterialsConnect.getValue());
        object.addProperty("enableBook", this.enableBook.getValue());
        object.addProperty("differentMirrorsConnect", this.differentMirrorsConnect.getValue());
        object.addProperty("mobsSitOnChairs", this.mobsSitOnChairs.getValue());
        object.addProperty("renderImmersivePortalsMirrors", this.renderImmersivePortalsMirrors.getValue());
        object.addProperty("spawnImmersivePortalsMirror", this.spawnImmersivePortalsMirror.getValue());
        object.addProperty("disableGeneratingScreen", this.disableGeneratingScreen.getValue());
        try (FileWriter writer = new FileWriter(this.propertiesPath.toString());){
            GSON.toJson((JsonElement)object, (Appendable)writer);
        }
    }
}

