/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.DynamicBlockRegistry;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariantBase<T>
implements class_3542,
Comparable<VariantBase<T>> {
    private final BiMap<String, Object> children = HashBiMap.create();
    public final class_2960 identifier;

    protected VariantBase(class_2960 id) {
        this.identifier = id;
    }

    @Environment(value=EnvType.CLIENT)
    public abstract class_2960 getTexture(BlockType var1);

    public abstract String getPath();

    public abstract class_2248 getBaseBlock();

    public abstract class_2248 getSecondaryBlock();

    public abstract boolean isNetherWood();

    public abstract T getVariantType();

    public abstract List<class_7696> getFeatureList();

    public String getNamespace() {
        return this.identifier.method_12836();
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public abstract boolean isVanilla();

    @Nullable
    protected <V> V findRelatedEntry(String appendedName, class_2378<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String append, String postPend, class_2378<V> reg) {
        Optional o;
        if (this.identifier.method_12836().equals("tfc") && (o = reg.method_17966(class_2960.method_60655((String)this.identifier.method_12836(), (String)("wood/" + postPend + "/" + this.identifier.method_12832())))).isPresent()) {
            return (V)o.get();
        }
        Object post = postPend.isEmpty() ? "" : "_" + postPend;
        class_2960[] targets = new class_2960[]{class_2960.method_60655((String)this.identifier.method_12836(), (String)(this.identifier.method_12832() + "_" + append + (String)post)), class_2960.method_60655((String)this.identifier.method_12836(), (String)(append + "_" + this.identifier.method_12832() + (String)post)), class_2960.method_60655((String)this.identifier.method_12836(), (String)(this.identifier.method_12832() + "_planks_" + append + (String)post))};
        Object found = null;
        for (class_2960 r : targets) {
            if (!reg.method_10250(r)) continue;
            found = reg.method_63535(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    @Nullable
    public class_1792 getItemOfThis(String key) {
        class_1792 i;
        Object v = this.getChild(key);
        return v instanceof class_1792 ? (i = (class_1792)v) : null;
    }

    @Nullable
    public class_2248 getBlockOfThis(String key) {
        class_2248 b;
        Object v = this.getChild(key);
        return v instanceof class_2248 ? (b = (class_2248)v) : null;
    }

    @Nullable
    public Object getChild(String key) {
        if (this.children.get((Object)key) != null) {
            return this.children.get((Object)key);
        }
        return this.getBaseBlock();
    }

    @Nullable
    public class_1935 getItemForRecipe(String key, Class<? extends class_2248> blockClass) {
        if (Objects.equals(key, "base")) {
            return this.getBaseBlock();
        }
        if (Objects.equals(key, "secondary")) {
            return this.getSecondaryBlock();
        }
        if (this.children.get((Object)key) != null) {
            return (class_1935)this.children.get((Object)key);
        }
        return this.getBaseBlock();
    }

    public void addChild(String genericName, @Nullable Object itemLike) {
        if (itemLike != null) {
            this.children.put((Object)genericName, itemLike);
            VariantRegistryBase<?> v = DynamicBlockRegistry.getBlockSet(this.getClass());
            if (v != null) {
                v.mapBlockToType(itemLike, this);
            }
        }
    }

    public boolean isEnabled(class_7699 set) {
        for (class_7696 flag : this.getFeatureList()) {
            if (set.method_45403(flag)) continue;
            return false;
        }
        return true;
    }

    public abstract void initializeChildrenBlocks();

    public abstract void initializeChildrenItems();

    public abstract class_2248 mainChild();

    @Nullable
    public String getChildKey(Object child) {
        return (String)this.children.inverse().get(child);
    }

    @Nullable
    public static Object changeType(Object current, VariantBase<?> originalMat, VariantBase<?> destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    @Nullable
    public static class_1792 changeItemType(class_1792 current, VariantBase<?> originalMat, VariantBase<?> destinationMat) {
        class_2248 il;
        class_1792 i;
        class_1747 bi;
        Object blockChanged;
        Object changed = VariantBase.changeType(current, originalMat, destinationMat);
        if (changed == null && current instanceof class_1747 && (blockChanged = VariantBase.changeType((bi = (class_1747)current).method_7711(), originalMat, destinationMat)) instanceof class_2248 && (i = (il = (class_2248)blockChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_1792) {
            class_1792 il2 = (class_1792)changed;
            return il2.method_8389();
        }
        return null;
    }

    @Nullable
    public static class_2248 changeBlockType(@NotNull class_2248 current, VariantBase<?> originalMat, VariantBase<?> destinationMat) {
        class_1747 bi;
        class_1792 i;
        Object itemChanged;
        Object changed = VariantBase.changeType(current, originalMat, destinationMat);
        if (changed == null && current.method_8389() != class_1802.field_8162 && (itemChanged = VariantBase.changeType(current.method_8389(), originalMat, destinationMat)) instanceof class_1747 && (i = (bi = (class_1747)itemChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_2248) {
            class_2248 b = (class_2248)changed;
            return b;
        }
        return null;
    }

    @Override
    public int compareTo(@NotNull VariantBase<T> o) {
        return this.identifier.method_12833(o.identifier);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VariantBase)) {
            return false;
        }
        VariantBase that = (VariantBase)object;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    @FunctionalInterface
    public static interface SetFinder<T extends VariantBase<T>>
    extends Supplier<Optional<T>> {
        @Override
        public Optional<T> get();
    }
}

