/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.menus;

import com.google.common.collect.Lists;
import com.unlikepaladin.pfm.menus.fabric.WorkbenchScreenHandlerImpl;
import com.unlikepaladin.pfm.mixin.ServerRecipeManagerAccessor;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import com.unlikepaladin.pfm.registry.ScreenHandlerIDs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public class WorkbenchScreenHandler
extends class_1703 {
    private final class_3914 context;
    private final List<FurnitureRecipe.CraftableFurnitureRecipe> availableRecipes = Lists.newArrayList();
    public static ArrayList<FurnitureRecipe> ALL_RECIPES = Lists.newArrayList();
    public static ArrayList<FurnitureRecipe.CraftableFurnitureRecipe> CRAFTABLE_RECIPES = Lists.newArrayList();
    private final List<FurnitureRecipe.CraftableFurnitureRecipe> sortedRecipes = Lists.newArrayList();
    private final List<FurnitureRecipe.CraftableFurnitureRecipe> searchableRecipes = Lists.newArrayList();
    private final class_3915 selectedRecipe = class_3915.method_17403();
    private final class_1937 world;
    final class_1735 outputSlot;
    final class_1731 output = new class_1731();
    long lastTakeTime;
    final class_1661 playerInventory;
    Runnable contentsChangedListener;
    public boolean searching = false;

    public WorkbenchScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public WorkbenchScreenHandler(int syncId, class_1661 playerInventory, final class_3914 context) {
        super(ScreenHandlerIDs.WORKBENCH_SCREEN_HANDLER, syncId);
        int i;
        this.context = context;
        this.world = playerInventory.field_7546.method_37908();
        this.playerInventory = playerInventory;
        this.contentsChangedListener = () -> {};
        this.outputSlot = this.method_7621(new class_1735((class_1263)this.output, 0, 143, 50){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                if (WorkbenchScreenHandler.this.craft()) {
                    stack.method_7982(player, stack.method_7947());
                    WorkbenchScreenHandler.this.output.method_7664(player, List.of());
                    WorkbenchScreenHandler.this.populateResult(player);
                    context.method_17393((world, pos) -> {
                        long l = world.method_8510();
                        if (WorkbenchScreenHandler.this.lastTakeTime != l) {
                            world.method_8396(null, pos, class_3417.field_17710, class_3419.field_15245, 1.0f, 1.0f);
                            WorkbenchScreenHandler.this.lastTakeTime = l;
                        }
                    });
                    WorkbenchScreenHandler.this.contentsChangedListener.run();
                    WorkbenchScreenHandler.this.updateInput();
                    super.method_7667(player, stack);
                }
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 98 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 156));
        }
        this.method_17362(this.selectedRecipe);
        if (this.world instanceof class_3218) {
            if (ALL_RECIPES.isEmpty() || CRAFTABLE_RECIPES.isEmpty()) {
                CRAFTABLE_RECIPES.clear();
                ALL_RECIPES.clear();
                ((ServerRecipeManagerAccessor)((class_3218)this.world).method_64577()).getPreparedRecipes().method_64698(RecipeTypes.FURNITURE_RECIPE).stream().map(class_8786::comp_1933).forEach(recipe -> {
                    ALL_RECIPES.add((FurnitureRecipe)recipe);
                    CRAFTABLE_RECIPES.addAll(recipe.getInnerRecipes(this.world.method_45162()));
                });
                CRAFTABLE_RECIPES.sort(FurnitureRecipe.CraftableFurnitureRecipe::compareTo);
            }
            WorkbenchScreenHandler.sendSyncRecipesPayload(playerInventory.field_7546, this.world, ALL_RECIPES);
        }
        this.updateInput();
        this.selectedRecipe.method_17404(-1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendSyncRecipesPayload(class_1657 player, class_1937 world, ArrayList<FurnitureRecipe> recipes) {
        void var2_2;
        void var1_1;
        WorkbenchScreenHandlerImpl.sendSyncRecipesPayload(player, (class_1937)var1_1, (ArrayList<FurnitureRecipe>)var2_2);
    }

    public static void setAllRecipes(class_1937 world, List<FurnitureRecipe> recipes) {
        if (!ALL_RECIPES.isEmpty()) {
            return;
        }
        ALL_RECIPES.addAll(recipes);
        CRAFTABLE_RECIPES.clear();
        for (FurnitureRecipe recipe : ALL_RECIPES) {
            CRAFTABLE_RECIPES.addAll(recipe.getInnerRecipes(world.method_45162()));
        }
        CRAFTABLE_RECIPES.sort(FurnitureRecipe.CraftableFurnitureRecipe::compareTo);
    }

    boolean craft() {
        FurnitureRecipe.FurnitureRecipeInput furnitureRecipeInput;
        FurnitureRecipe.CraftableFurnitureRecipe simpleFurnitureRecipe;
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.availableRecipes, this.selectedRecipe.method_17407()) && (simpleFurnitureRecipe = this.sortedRecipes.get(this.selectedRecipe.method_17407())).matches(furnitureRecipeInput = new FurnitureRecipe.FurnitureRecipeInput(this.playerInventory), this.playerInventory.field_7546.method_37908())) {
            simpleFurnitureRecipe.craftAndRemoveItems(furnitureRecipeInput, (class_7225.class_7874)this.playerInventory.field_7546.method_37908().method_30349());
            return true;
        }
        return false;
    }

    void populateResult(class_1657 player) {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.availableRecipes, this.selectedRecipe.method_17407())) {
            FurnitureRecipe.CraftableFurnitureRecipe simpleFurnitureRecipe = this.sortedRecipes.get(this.selectedRecipe.method_17407());
            this.outputSlot.method_53512(simpleFurnitureRecipe.craft(new FurnitureRecipe.FurnitureRecipeInput(player.method_31548()), (class_7225.class_7874)player.method_37908().method_30349()));
        } else {
            this.outputSlot.method_53512(class_1799.field_8037);
        }
        this.method_7623();
    }

    public boolean isInBounds(List<FurnitureRecipe.CraftableFurnitureRecipe> simpleFurnitureRecipes, int id) {
        if (id >= simpleFurnitureRecipes.size() || id < 0) {
            return false;
        }
        return simpleFurnitureRecipes.contains(this.getSortedRecipes().get(id));
    }

    public void method_7609(class_1263 inventory) {
        this.updateInput();
        super.method_7609(inventory);
    }

    public class_1661 getPlayerInventory() {
        return this.playerInventory;
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.method_17407();
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getSortedRecipes() {
        return this.sortedRecipes;
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getAllRecipes() {
        return CRAFTABLE_RECIPES;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public int getTotalRecipeCount() {
        return this.sortedRecipes.size();
    }

    public int getVisibleRecipeCount() {
        return this.searching ? this.searchableRecipes.size() : this.getTotalRecipeCount();
    }

    public void updateInput() {
        FurnitureRecipe.FurnitureRecipeInput input = new FurnitureRecipe.FurnitureRecipeInput(this.playerInventory);
        if (!this.availableRecipes.isEmpty() && this.getSelectedRecipe() != -1 && !this.sortedRecipes.get(this.getSelectedRecipe()).matches(input, this.world)) {
            this.selectedRecipe.method_17404(-1);
            this.outputSlot.method_53512(class_1799.field_8037);
        }
        this.availableRecipes.clear();
        this.availableRecipes.addAll(CRAFTABLE_RECIPES.stream().filter(newFurnitureRecipe -> newFurnitureRecipe.matches(input, this.world)).toList());
        this.sortedRecipes.clear();
        this.sortedRecipes.addAll(this.availableRecipes);
        this.sortedRecipes.addAll(CRAFTABLE_RECIPES.stream().filter(furnitureRecipe -> !this.sortedRecipes.contains(furnitureRecipe)).toList());
    }

    public boolean canCraft() {
        return !this.availableRecipes.isEmpty();
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public boolean method_7597(class_1657 player) {
        return WorkbenchScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)PaladinFurnitureModBlocksItems.WORKING_TABLE);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.outputSlot && super.method_7613(stack, slot);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 itemStack2 = slot.method_7677();
            class_1792 item = itemStack2.method_7909();
            itemStack = itemStack2.method_7972();
            if (index == 0) {
                item.method_54465(itemStack2, player);
                if (!this.method_7616(itemStack2, 1, 37, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemStack2, itemStack);
            } else if (index >= 1 && index < 28 ? !this.method_7616(itemStack2, 28, 37, false) : index >= 28 && index < 37 && !this.method_7616(itemStack2, 1, 28, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            }
            slot.method_7668();
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
            this.method_7623();
        }
        return itemStack;
    }

    public boolean method_7604(class_1657 player, int id) {
        this.updateInput();
        if (this.isInBounds(this.availableRecipes, id) && this.canCraft()) {
            this.selectedRecipe.method_17404(id);
            this.populateResult(player);
            return true;
        }
        return false;
    }

    public List<FurnitureRecipe.CraftableFurnitureRecipe> getSearchableRecipes() {
        return this.searchableRecipes;
    }
}

