/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.unlikepaladin.pfm.runtime.PFMResourceProgress;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Logger;

public abstract class PFMGenerator
implements PFMResourceProgress {
    protected final Path output;
    private final boolean logOrDebug;
    private final Logger logger;
    public static final HashFunction SHA1 = Hashing.sha1();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final JsonParser JSON_PARSER = new JsonParser();
    private static boolean assetsRunning = false;
    private static boolean dataRunning = false;
    private String progress;
    private String notification = null;
    private int progressCount = 0;
    private int totalCount = 0;

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public synchronized void setNotification(String notification) {
        this.notification = notification;
    }

    public synchronized void incrementCount() {
        ++this.progressCount;
    }

    public void setCount(int count) {
        this.progressCount = count;
        this.setProgress("Progress: " + this.progressCount + " / " + this.totalCount);
    }

    protected PFMGenerator(Path output, boolean logOrDebug, Logger logger) {
        this.output = output;
        this.logOrDebug = logOrDebug;
        this.logger = logger;
    }

    protected void createPackIcon() {
        File file = new File(this.output.toFile(), "pack.png");
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(PFMRuntimeResources.getImageData()));
            ImageIO.write((RenderedImage)image, "png", file);
            image.flush();
        }
        catch (IOException e) {
            this.logger.warn("Failed to create resource icon {}", (Object)e.getMessage());
        }
    }

    public static boolean areAssetsRunning() {
        return assetsRunning;
    }

    public static boolean isDataRunning() {
        return dataRunning;
    }

    protected static void setAssetsRunning(boolean running) {
        assetsRunning = running;
    }

    protected static void setDataRunning(boolean running) {
        dataRunning = running;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getOutput() {
        return this.output;
    }

    public Path getOrCreateSubDirectory(String name) {
        return PFMRuntimeResources.createDirIfNeeded(this.output.resolve(name));
    }

    public abstract void run() throws IOException;

    public synchronized void log(String s, Object p0) {
        this.log(s, p0, "");
    }

    public synchronized void log(String s) {
        this.log(s, "", "");
    }

    public synchronized void error(String s) {
        this.error(s, "", "");
    }

    public synchronized void error(String s, Object p0, Object p1) {
        this.logger.error(s, p0, p1);
    }

    public synchronized void log(String s, Object p0, Object p1) {
        if (this.logOrDebug) {
            this.logger.info(s, p0, p1);
        } else {
            this.logger.debug(s, p0, p1);
        }
    }

    public List<String> hashDirectory(File directory, boolean includeHiddenFiles) throws IOException {
        if (!directory.isDirectory()) {
            this.logger.error("Not a directory");
            throw new IllegalArgumentException("Not a directory");
        }
        Vector<String> fileStreams = new Vector<String>();
        this.collectFiles(directory, fileStreams, includeHiddenFiles);
        return fileStreams;
    }

    private void collectFiles(File directory, List<String> hashList, boolean includeHiddenFiles) throws IOException {
        File[] fileArray = directory.listFiles();
        if (fileArray != null) {
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(fileArray));
            files.removeIf(file -> file.getName().equals("pfmCacheData.json"));
            files.sort(Comparator.comparing(File::getName));
            for (File file2 : files) {
                if (file2 == null || file2.getName().equals("pfmCacheData.json") || !includeHiddenFiles && Files.isHidden(file2.toPath())) continue;
                if (file2.isDirectory()) {
                    this.collectFiles(file2, hashList, includeHiddenFiles);
                    continue;
                }
                FileInputStream stream = new FileInputStream(file2);
                try {
                    HashCode code = HashCode.fromBytes((byte[])stream.readAllBytes());
                    hashList.add(code.toString());
                }
                catch (Exception e) {
                    this.logger.warn("File {} was less than 1 byte or invalid, skipping, {}", (Object)file2.getName(), (Object)e);
                }
                stream.close();
            }
        }
    }

    @Override
    public float getProgress() {
        return (float)this.progressCount / (float)this.totalCount;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    @Override
    public String getProgressString() {
        return this.progress;
    }

    @Override
    public String getNotificationProgressString() {
        return this.notification;
    }

    public static final class PFMCache {
        private final String gameVersion;
        private final String modVersion;
        private final PFMFileUtil.ModLoader modLoader;
        private final List<String> folderHash;
        private final List<class_2960> variants;

        public PFMCache(String gameVersion, String modVersion, PFMFileUtil.ModLoader modLoader, List<String> folderHash, List<class_2960> variants) {
            this.gameVersion = gameVersion;
            this.modVersion = modVersion;
            this.modLoader = modLoader;
            this.folderHash = folderHash;
            this.variants = variants;
        }

        public String gameVersion() {
            return this.gameVersion;
        }

        public String modVersion() {
            return this.modVersion;
        }

        public PFMFileUtil.ModLoader modLoader() {
            return this.modLoader;
        }

        public List<String> folderHash() {
            return this.folderHash;
        }

        public List<class_2960> variants() {
            return this.variants;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PFMCache that = (PFMCache)obj;
            return Objects.equals(this.gameVersion, that.gameVersion) && Objects.equals(this.modVersion, that.modVersion) && Objects.equals((Object)this.modLoader, (Object)that.modLoader) && Objects.equals(this.variants, that.variants) && Objects.equals(this.folderHash, that.folderHash);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.gameVersion, this.modVersion, this.modLoader, this.folderHash, this.variants});
        }

        public String toString() {
            return "PFMCache{gameVersion='" + this.gameVersion + "'modVersion='" + this.modVersion + "', modLoader=" + String.valueOf((Object)this.modLoader) + ", variants=" + String.valueOf(this.variants) + ", folderHash=" + String.valueOf(this.folderHash) + "}";
        }

        public JsonElement toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("game_version", this.gameVersion);
            obj.addProperty("mod_version", this.modVersion);
            obj.addProperty("mod_loader", this.modLoader.method_15434());
            JsonArray registeredVariants = new JsonArray();
            for (class_2960 variant : this.variants) {
                registeredVariants.add(variant.toString());
            }
            obj.add("block_variants", (JsonElement)registeredVariants);
            JsonArray folderHashArray = new JsonArray();
            for (String hash : this.folderHash) {
                folderHashArray.add(hash);
            }
            obj.add("folder_hash", (JsonElement)folderHashArray);
            return obj;
        }

        public static PFMCache fromJson(JsonElement json) {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                String modVersion = "0";
                ArrayList<String> folderHash = new ArrayList<String>();
                PFMFileUtil.ModLoader modLoader = PFMFileUtil.ModLoader.INVALID;
                ArrayList<class_2960> variants = new ArrayList<class_2960>();
                String gameVersion = "0";
                if (jsonObject.has("game_version")) {
                    gameVersion = jsonObject.get("game_version").getAsString();
                }
                if (jsonObject.has("mod_version")) {
                    modVersion = jsonObject.get("mod_version").getAsString();
                }
                if (jsonObject.has("mod_loader")) {
                    modLoader = PFMFileUtil.ModLoader.get(jsonObject.get("mod_loader").getAsString());
                }
                if (jsonObject.has("block_variants") && jsonObject.get("block_variants").isJsonArray()) {
                    for (JsonElement jsonElement : jsonObject.getAsJsonArray("block_variants")) {
                        variants.add(class_2960.method_12829((String)jsonElement.getAsString()));
                    }
                }
                if (jsonObject.has("folder_hash") && jsonObject.get("folder_hash").isJsonArray()) {
                    for (JsonElement jsonElement : jsonObject.getAsJsonArray("folder_hash")) {
                        folderHash.add(jsonElement.getAsString());
                    }
                }
                return new PFMCache(gameVersion, modVersion, modLoader, folderHash, variants);
            }
            return new PFMCache("0", "0", PFMFileUtil.ModLoader.INVALID, Collections.emptyList(), Collections.emptyList());
        }
    }
}

