/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public abstract class PFMProvider {
    private final PFMGenerator parent;
    private final String providerName;
    private final Stopwatch stopwatch;
    private CountDownLatch countDownLatch;
    private BlockingQueue<Map.Entry<Path, String>> writeQueue;
    private static final Map.Entry<Path, String> DONE_SIGNAL = Map.entry(PFMFileUtil.getGamePath(), "DONE");
    private ExecutorService writerExecutor;

    public PFMProvider(PFMGenerator parent, String providerName) {
        this.parent = parent;
        this.providerName = providerName;
        this.stopwatch = Stopwatch.createUnstarted();
    }

    protected void startProviderRun() {
        this.parent.log("Starting provider: {}", this.providerName);
        this.stopwatch.start();
    }

    protected void endProviderRun() {
        this.stopwatch.stop();
        String notification = String.format("%s finished after %s ms", this.providerName, this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.parent.log(notification);
        this.parent.setNotification(notification);
        this.parent.incrementCount();
    }

    protected <T> void generateAndQueueJsons(Path root, Map<T, ? extends Supplier<JsonElement>> jsons, BiFunction<Path, T, Path> locator, BlockingQueue<Map.Entry<Path, String>> queue) {
        jsons.forEach((object, supplier) -> {
            if (supplier != null && supplier.get() != null) {
                Path filePath = (Path)locator.apply(root, object);
                String jsonContent = PFMDataGenerator.GSON.toJson((JsonElement)supplier.get());
                this.enqueueJsonWrite(queue, filePath, jsonContent);
            }
        });
    }

    protected void enqueueJsonWrite(BlockingQueue<Map.Entry<Path, String>> queue, Path path, String content) {
        try {
            queue.put(Map.entry(path, content));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void enqueueJsonWrite(BlockingQueue<Map.Entry<Path, String>> queue, Path path, JsonElement element) {
        try {
            queue.put(Map.entry(path, PFMDataGenerator.GSON.toJson(element)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected BlockingQueue<Map.Entry<Path, String>> getWriteQueue() {
        return this.writeQueue;
    }

    public abstract void run();

    public void createWriter() {
        this.countDownLatch = new CountDownLatch(1);
        this.writeQueue = new LinkedBlockingQueue<Map.Entry<Path, String>>();
        this.writerExecutor = Executors.newSingleThreadExecutor();
        this.writerExecutor.submit(() -> {
            block10: {
                block6: while (true) {
                    try {
                        while (true) {
                            Map.Entry<Path, String> entry;
                            if ((entry = this.writeQueue.take()) == DONE_SIGNAL) {
                                break block10;
                            }
                            Path filePath = entry.getKey();
                            String content = entry.getValue();
                            try {
                                if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                                }
                                Files.writeString(filePath, (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                                continue block6;
                            }
                            catch (Exception e) {
                                this.getParent().getLogger().error("Couldn't save {}", (Object)filePath, (Object)e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        break block10;
                    }
                }
                finally {
                    this.countDownLatch.countDown();
                }
            }
        });
    }

    public void waitForWrite() {
        this.writeQueue.add(DONE_SIGNAL);
        this.writerExecutor.shutdown();
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            this.parent.getLogger().info("Interrupted while waiting for write to finish {}", (Object)e.getMessage());
        }
    }

    public PFMGenerator getParent() {
        return this.parent;
    }
}

