/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.unlikepaladin.pfm.blocks.BasicBathtubBlock;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.runtime.PFMDataGenerator;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_192;
import net.minecraft.class_1935;
import net.minecraft.class_212;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;

public class PFMLootTableProvider
extends PFMProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<class_2960, class_52.class_53>>>, class_176>> lootTypeGenerators = ImmutableList.of((Object)Pair.of(PFMLootTableGenerator::new, (Object)class_173.field_1172));

    public PFMLootTableProvider(PFMGenerator parent) {
        super(parent, "PFM Drops");
        parent.setProgress("Generating Loot Tables");
    }

    @Override
    public void run() {
        this.startProviderRun();
        this.createWriter();
        Path path = this.getParent().getOutput();
        HashSet identifiers = new HashSet();
        this.lootTypeGenerators.forEach(pair -> ((Consumer)((Supplier)pair.getFirst()).get()).accept((identifier, builder) -> {
            if (!identifiers.add(identifier)) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(identifier));
            }
            Path path2 = PFMLootTableProvider.getOutput(path, identifier);
            String string = PFMDataGenerator.GSON.toJson((JsonElement)class_52.field_50021.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)builder.method_338()).getOrThrow(error -> {
                this.getParent().getLogger().warn("Failed to parse Loot table: {}", error);
                return null;
            }));
            this.enqueueJsonWrite(this.getWriteQueue(), path2, string);
        }));
        this.waitForWrite();
        this.endProviderRun();
    }

    public String getName() {
        return "PFM Loot Tables";
    }

    private static Path getOutput(Path rootOutput, class_2960 lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.method_12836() + "/loot_table/" + lootTableId.method_12832() + ".json");
    }

    static class PFMLootTableGenerator
    implements Consumer<BiConsumer<class_2960, class_52.class_53>> {
        private final Map<class_2960, class_52.class_53> lootTables = Maps.newHashMap();
        private final List<class_2248> pfmBlocks = new ArrayList<class_2248>();

        PFMLootTableGenerator() {
        }

        @Override
        public void accept(BiConsumer<class_2960, class_52.class_53> biConsumer) {
            List<class_2248> blocks = PaladinFurnitureModBlocksItems.BLOCKS;
            blocks.forEach(this::addDrop);
            class_2248[] beds = PaladinFurnitureModBlocksItems.getBeds();
            Arrays.stream(beds).forEach(bed -> this.addDrop((class_2248)bed, (class_2248 block) -> this.dropsWithProperty((class_2248)block, (class_2769)class_2244.field_9967, (Comparable<T> & class_3542)class_2742.field_12560)));
            BasicBathtubBlock.basicBathtubBlockStream().forEach(basicBathtubBlock -> this.addDrop((class_2248)basicBathtubBlock, (class_2248 block) -> this.dropsWithProperty((class_2248)block, (class_2769)class_2244.field_9967, (Comparable<T> & class_3542)class_2742.field_12560)));
            HashSet set = Sets.newHashSet();
            for (class_2248 block : this.pfmBlocks) {
                class_2960 identifier;
                if (block.method_26162().isEmpty() || !set.add(identifier = ((class_5321)block.method_26162().get()).method_29177())) continue;
                class_52.class_53 builder5 = this.lootTables.remove(identifier);
                if (builder5 == null) {
                    throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", identifier, class_7923.field_41175.method_10221((Object)block)));
                }
                biConsumer.accept(identifier, builder5);
            }
            if (!this.lootTables.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.lootTables.keySet()));
            }
        }

        private void addDrop(class_2248 block, Function<class_2248, class_52.class_53> lootTableFunction) {
            this.addDrop(block, lootTableFunction.apply(block));
        }

        public void addDrop(class_2248 block, class_2248 drop) {
            this.addDrop(block, this.drops((class_1935)drop));
        }

        public class_52.class_53 drops(class_1935 drop) {
            return class_52.method_324().method_336((class_55.class_56)this.addSurvivesExplosionCondition(drop, (class_192)class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)drop))));
        }

        public void addDrop(class_2248 block) {
            this.addDrop(block, block);
        }

        public final void addDrop(class_2248 block, class_52.class_53 lootTable) {
            this.lootTables.put(((class_5321)block.method_26162().get()).method_29177(), lootTable);
            this.pfmBlocks.add(block);
        }

        public <T extends Comparable<T> & class_3542> class_52.class_53 dropsWithProperty(class_2248 drop, class_2769<T> property, T value) {
            return class_52.method_324().method_336((class_55.class_56)this.addSurvivesExplosionCondition((class_1935)drop, (class_192<T>)class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(class_77.method_411((class_1935)drop).method_421((class_5341.class_210)class_212.method_900((class_2248)drop).method_22584(class_4559.class_4560.method_22523().method_22525(property, value))))));
        }

        protected <T extends class_192<T>> T addSurvivesExplosionCondition(class_1935 drop, class_192<T> builder) {
            return (T)builder.method_512();
        }
    }
}

