/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.utilities.fabric;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;

public class VersionImpl {
    public static boolean getVersion(String targetVersionNum) {
        SemanticVersion targetVersion;
        SemanticVersion currentVersion;
        Optional modContainer = FabricLoader.getInstance().getModContainer("pfm");
        if (!modContainer.isPresent()) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Couldn't find container for PFM, something is incredibly wrong");
            return false;
        }
        try {
            currentVersion = SemanticVersion.parse((String)((ModContainer)modContainer.get()).getMetadata().getVersion().getFriendlyString());
            targetVersion = SemanticVersion.parse((String)targetVersionNum);
        }
        catch (VersionParsingException exception) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("[Paladin's Furniture Update Check] Caught a VersionParsingException while parsing semantic versions!", (Throwable)exception);
            return false;
        }
        return currentVersion.compareTo(targetVersion) < 0;
    }

    public static String getCurrentVersion() {
        if (!FabricLoader.getInstance().getModContainer("pfm").isPresent()) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Couldn't find container for PFM, something is incredibly wrong");
            return "0";
        }
        return ((ModContainer)FabricLoader.getInstance().getModContainer("pfm").get()).getMetadata().getVersion().getFriendlyString();
    }

    public static boolean compareVersions(String targetVersionNum, String version2) {
        SemanticVersion targetVersion;
        SemanticVersion currentVersion;
        try {
            currentVersion = SemanticVersion.parse((String)((ModContainer)FabricLoader.getInstance().getModContainer("pfm").get()).getMetadata().getVersion().getFriendlyString());
            targetVersion = SemanticVersion.parse((String)targetVersionNum);
        }
        catch (VersionParsingException exception) {
            PaladinFurnitureMod.GENERAL_LOGGER.error("Caught a VersionParsingException while parsing semantic versions!", (Throwable)exception);
            return false;
        }
        return currentVersion.compareTo(targetVersion) < 0;
    }
}

