/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tweaker.hook;

import java.util.ArrayList;
import java.util.List;
import org.tlauncher.tweaker.Tweaker;
import org.tlauncher.tweaker.hook.HookClassData;
import org.tlauncher.tweaker.hook.HookMethodData;
import org.tlauncher.util.TLModCfg;

public final class HookRegistry {
    private static final List<HookClassData> HOOK_CLASS_DATA = new ArrayList<HookClassData>();
    private static final List<HookMethodData> HOOK_METHOD_DATA = new ArrayList<HookMethodData>();

    public static void register(String version, HookMethodData ... hookDataArr) {
        for (HookMethodData hookData : hookDataArr) {
            if (!version.equals(TLModCfg.getMinecraftVersion().getVersion())) continue;
            HOOK_METHOD_DATA.add(hookData);
            Tweaker.logger.info("Hook method %s#%s%s loaded.", hookData.getClassName(), hookData.getMethodName(), hookData.getDescriptor());
        }
    }

    public static void register(String version, HookClassData ... hookDataArr) {
        for (HookClassData hookData : hookDataArr) {
            if (!version.equals(TLModCfg.getMinecraftVersion().getVersion())) continue;
            HOOK_CLASS_DATA.add(hookData);
            Tweaker.logger.info("Hook method of class %s loaded.", hookData.getClassName());
        }
    }

    public static List<HookMethodData> getHookMethodData() {
        return HOOK_METHOD_DATA;
    }

    public static List<HookClassData> getHookClassData() {
        return HOOK_CLASS_DATA;
    }

    private HookRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

