/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc;

import com.google.common.base.Objects;
import com.google.common.collect.MapMaker;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.util.concurrent.ConcurrentMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc.IMixinServerPlayer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.phys.Vec3;

public class ServerPlayerWrapper
implements IServerPlayerWrapper {
    private static final ConcurrentMap<ServerGamePacketListenerImpl, ServerPlayerWrapper> serverPlayerWrapperMap = new MapMaker().weakKeys().weakValues().makeMap();
    private final ServerGamePacketListenerImpl connection;

    public static ServerPlayerWrapper getWrapper(ServerPlayer serverPlayer) {
        return serverPlayerWrapperMap.computeIfAbsent(serverPlayer.connection, ignored -> new ServerPlayerWrapper(serverPlayer.connection));
    }

    private ServerPlayerWrapper(ServerGamePacketListenerImpl connection) {
        this.connection = connection;
    }

    private ServerPlayer getServerPlayer() {
        return this.connection.player;
    }

    @Override
    public String getName() {
        return this.getServerPlayer().getName().getString();
    }

    @Override
    public IServerLevelWrapper getLevel() {
        ServerLevel level = ((IMixinServerPlayer)this.getServerPlayer()).distantHorizons$getDimensionChangeDestination();
        if (level == null) {
            level = this.getServerPlayer().serverLevel();
        }
        return ServerLevelWrapper.getWrapper(level);
    }

    @Override
    public Vec3d getPosition() {
        Vec3 position = this.getServerPlayer().position();
        return new Vec3d(position.x, position.y, position.z);
    }

    @Override
    public Object getWrappedMcObject() {
        return this.getServerPlayer();
    }

    public String toString() {
        return "Wrapped{" + String.valueOf(this.getServerPlayer()) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServerPlayerWrapper)) {
            return false;
        }
        ServerPlayerWrapper that = (ServerPlayerWrapper)obj;
        return Objects.equal((Object)this.connection, (Object)that.connection);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connection});
    }
}

