/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image;

import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.image.ImageRendererManager;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import org.jetbrains.annotations.NotNull;

public class YACLImageReloadListener
implements class_3302,
IdentifiableResourceReloadListener {
    @NotNull
    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        return ((CompletableFuture)this.prepare(resourceManager, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenCompose(suppliers -> this.apply((List<Optional<SupplierPreparation>>)suppliers, gameExecutor));
    }

    private CompletableFuture<List<Optional<SupplierPreparation>>> prepare(class_3300 manager, Executor executor) {
        Map imageResources = manager.method_14488("textures", location -> ImageRendererManager.PRELOADED_IMAGE_FACTORIES.stream().anyMatch(factory -> factory.predicate().test((class_2960)location)));
        return imageResources.keySet().stream().map(location -> {
            ImageRendererFactory imageFactory = ImageRendererManager.PRELOADED_IMAGE_FACTORIES.stream().filter(factory -> factory.predicate().test((class_2960)location)).map(factory -> factory.factory().apply((class_2960)location)).findAny().orElseThrow();
            return CompletableFuture.supplyAsync(() -> ImageRendererManager.safelyPrepareFactory(location, imageFactory).map(supplier -> new SupplierPreparation((class_2960)location, (ImageRendererFactory.ImageSupplier)supplier)), executor);
        }).collect(CompletableFutureCollector.allOf());
    }

    private CompletableFuture<Void> apply(List<Optional<SupplierPreparation>> suppliers, Executor executor) {
        return CompletableFuture.allOf((CompletableFuture[])suppliers.stream().flatMap(Optional::stream).map(prep -> CompletableFuture.supplyAsync(() -> {
            ImageRenderer imageRenderer;
            try {
                imageRenderer = prep.supplier().completeImage();
            }
            catch (Exception e) {
                YACLConstants.LOGGER.error("Failed to create image '{}'", (Object)prep.location(), (Object)e);
                return Optional.empty();
            }
            ImageRendererManager.PRELOADED_IMAGE_CACHE.put(prep.location(), imageRenderer);
            YACLConstants.LOGGER.info("Successfully loaded image '{}'", (Object)prep.location());
            return Optional.of(imageRenderer);
        }, executor)).toArray(CompletableFuture[]::new));
    }

    public class_2960 getId() {
        return YACLPlatform.rl("image_reload_listener");
    }

    public class_2960 getFabricId() {
        return this.getId();
    }

    public static class CompletableFutureCollector<X, T extends CompletableFuture<X>>
    implements Collector<T, List<T>, CompletableFuture<List<X>>> {
        private CompletableFutureCollector() {
        }

        public static <X, T extends CompletableFuture<X>> Collector<T, List<T>, CompletableFuture<List<X>>> allOf() {
            return new CompletableFutureCollector<X, T>();
        }

        @Override
        public Supplier<List<T>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<T>, T> accumulator() {
            return List::add;
        }

        @Override
        public BinaryOperator<List<T>> combiner() {
            return (left, right) -> {
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<List<T>, CompletableFuture<List<X>>> finisher() {
            return ls -> CompletableFuture.allOf((CompletableFuture[])ls.toArray(CompletableFuture[]::new)).thenApply(v -> ls.stream().map(CompletableFuture::join).toList());
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }

    private record SupplierPreparation(class_2960 location, ImageRendererFactory.ImageSupplier supplier) {
    }
}

