/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.util;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;

public interface JsonSource {
    public static final JsonSource EMPTY = Optional::empty;

    public static JsonSource fromString(String string) {
        return () -> Optional.of((JsonObject)new Gson().fromJson(string, JsonObject.class));
    }

    public static JsonSource fromFile(String path) {
        return JsonSource.fromFile(Path.of(path, new String[0]));
    }

    public static JsonSource fromFile(Path path) {
        return () -> {
            try (BufferedReader in = Files.newBufferedReader(path);){
                Optional<JsonObject> optional = Optional.of((JsonObject)new Gson().fromJson((Reader)in, JsonObject.class));
                return optional;
            }
        };
    }

    public static JsonSource fromUrl(String url) {
        try {
            return JsonSource.fromUrl(new URL(url));
        }
        catch (MalformedURLException ignored) {
            return EMPTY;
        }
    }

    public static JsonSource fromUrl(URL url) {
        return () -> {
            URLConnection conn = url.openConnection();
            conn.connect();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                Optional<JsonObject> optional = Optional.of((JsonObject)new Gson().fromJson((Reader)in, JsonObject.class));
                return optional;
            }
        };
    }

    public static JsonSource fromResource(String path) {
        return () -> {
            InputStream resourceStream = JsonSource.class.getClassLoader().getResourceAsStream(path);
            if (resourceStream == null) {
                throw new IOException("Resource not found: " + path);
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(resourceStream));){
                Optional<JsonObject> optional = Optional.of((JsonObject)new Gson().fromJson((Reader)in, JsonObject.class));
                return optional;
            }
        };
    }

    public Optional<JsonObject> get() throws IOException, JsonSyntaxException, JsonIOException;

    default public Optional<JsonObject> getSafely(Consumer<Exception> errorHandler) {
        try {
            return this.get();
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            errorHandler.accept((Exception)e);
            return Optional.empty();
        }
    }

    default public Optional<JsonObject> getSilently() {
        return this.getSafely(e -> {});
    }

    default public JsonSource or(JsonSource other) {
        return () -> {
            Optional<JsonObject> thisJson = this.getSilently();
            return thisJson.isPresent() ? thisJson : other.get();
        };
    }
}

