/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Suppliers;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Color;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeFont;

public class DisplayHelper
implements IDisplayHelper {
    public static final DisplayHelper INSTANCE = new DisplayHelper();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final Pattern STRIP_COLOR = Pattern.compile("(?i)\u00a7[0-9A-F]");
    public static DecimalFormat dfCommas = new DecimalFormat("0.##");
    public static final DecimalFormat[] dfCommasArray = new DecimalFormat[]{dfCommas, new DecimalFormat("0.#"), new DecimalFormat("0")};
    private static final Supplier<JadeFont> FONT = Suppliers.memoize(() -> new JadeFont(class_310.method_1551().field_1772));

    private static void renderGuiItemDecorations(class_332 guiGraphics, class_327 font, class_1799 stack, int i, int j, @Nullable String text) {
        if (stack.method_7960()) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        if (stack.method_7947() != 1 || text != null) {
            String s = text == null ? INSTANCE.humanReadableNumber(stack.method_7947(), "", false, null) : text;
            boolean smaller = s.length() > 3;
            float scale = smaller ? 0.5f : 0.75f;
            int x = smaller ? 32 : 22;
            int y = smaller ? 23 : 13;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
            int color = IThemeHelper.get().theme().text.itemAmountColor();
            guiGraphics.method_51433(font, s, i + x - font.method_1727(s), j + y, color, true);
            guiGraphics.method_51448().method_22909();
        }
        if (stack.method_31578()) {
            int k = stack.method_31579();
            int l = stack.method_31580();
            int m = i + 2;
            int n = j + 13;
            guiGraphics.method_51739(class_1921.method_51785(), m, n, m + 13, n + 2, -16777216);
            guiGraphics.method_51739(class_1921.method_51785(), m, n, m + k, n + 1, l | 0xFF000000);
        }
        guiGraphics.method_51448().method_22909();
        ClientProxy.renderItemDecorationsExtra(guiGraphics, font, stack, i, j, text);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, class_4588 vertexConsumer, float xCoord, float yCoord, class_1058 textureSprite, float maskTop, float maskRight, float zLevel, int color) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= maskRight / 16.0f * (uMax - uMin);
        vMax -= maskTop / 16.0f * (vMax - vMin);
        vertexConsumer.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_39415(color);
        vertexConsumer.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_39415(color);
        vertexConsumer.method_22918(matrix, xCoord + 16.0f - maskRight, yCoord + maskTop, zLevel).method_22913(uMax, vMin).method_39415(color);
        vertexConsumer.method_22918(matrix, xCoord, yCoord + maskTop, zLevel).method_22913(uMin, vMin).method_39415(color);
    }

    public static void fill(class_332 guiGraphics, float minX, float minY, float maxX, float maxY, int color) {
        DisplayHelper.fill(guiGraphics, class_1921.method_51784(), minX, minY, maxX, maxY, color);
    }

    public static void fill(class_332 guiGraphics, class_1921 renderType, float minX, float minY, float maxX, float maxY, int color) {
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        color = IWailaConfig.Overlay.applyAlpha(color, OverlayRenderer.alpha);
        class_4588 buffer = guiGraphics.field_44658.getBuffer(renderType);
        buffer.method_22918(matrix, minX, maxY, 0.0f).method_39415(color);
        buffer.method_22918(matrix, maxX, maxY, 0.0f).method_39415(color);
        buffer.method_22918(matrix, maxX, minY, 0.0f).method_39415(color);
        buffer.method_22918(matrix, minX, minY, 0.0f).method_39415(color);
        guiGraphics.method_51452();
    }

    @Override
    public void drawItem(class_332 guiGraphics, float x, float y, class_1799 stack, float scale, @Nullable String text) {
        if (this.opacity() < 0.5f) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(x, y, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51445(stack, 0, 0);
        DisplayHelper.renderGuiItemDecorations(guiGraphics, DisplayHelper.font(), stack, 0, 0, text);
        guiGraphics.method_51448().method_22909();
    }

    @Override
    public void drawGradientRect(class_332 guiGraphics, float left, float top, float width, float height, int startColor, int endColor) {
        this.drawGradientRect(guiGraphics, left, top, width, height, startColor, endColor, false);
    }

    public void drawGradientRect(class_332 guiGraphics, float left, float top, float width, float height, int startColor, int endColor, boolean horizontal) {
        if (startColor == -1 && endColor == -1) {
            return;
        }
        float zLevel = 0.0f;
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        startColor = IWailaConfig.Overlay.applyAlpha(startColor, this.opacity());
        endColor = IWailaConfig.Overlay.applyAlpha(endColor, this.opacity());
        class_4588 buffer = guiGraphics.field_44658.getBuffer(class_1921.method_51784());
        if (horizontal) {
            buffer.method_22918(matrix, left + width, top, zLevel).method_39415(endColor);
            buffer.method_22918(matrix, left, top, zLevel).method_39415(startColor);
            buffer.method_22918(matrix, left, top + height, zLevel).method_39415(startColor);
            buffer.method_22918(matrix, left + width, top + height, zLevel).method_39415(endColor);
        } else {
            buffer.method_22918(matrix, left + width, top, zLevel).method_39415(startColor);
            buffer.method_22918(matrix, left, top, zLevel).method_39415(startColor);
            buffer.method_22918(matrix, left, top + height, zLevel).method_39415(endColor);
            buffer.method_22918(matrix, left + width, top + height, zLevel).method_39415(endColor);
        }
        guiGraphics.method_51452();
    }

    @Override
    public void drawBorder(class_332 guiGraphics, float minX, float minY, float maxX, float maxY, float width, int color, boolean corner) {
        DisplayHelper.fill(guiGraphics, minX + width, minY, maxX - width, minY + width, color);
        DisplayHelper.fill(guiGraphics, minX + width, maxY - width, maxX - width, maxY, color);
        if (corner) {
            DisplayHelper.fill(guiGraphics, minX, minY, minX + width, maxY, color);
            DisplayHelper.fill(guiGraphics, maxX - width, minY, maxX, maxY, color);
        } else {
            DisplayHelper.fill(guiGraphics, minX, minY + width, minX + width, maxY - width, color);
            DisplayHelper.fill(guiGraphics, maxX - width, minY + width, maxX, maxY - width, color);
        }
    }

    public void drawFluid(class_332 guiGraphics, float xPosition, float yPosition, JadeFluidObject fluid, float width, float height, long capacityMb) {
        if (fluid.isEmpty()) {
            return;
        }
        long amount = JadeFluidObject.bucketVolume();
        MutableFloat scaledAmount = new MutableFloat((float)amount * height / (float)capacityMb);
        if (amount > 0L && scaledAmount.floatValue() < 1.0f) {
            scaledAmount.setValue(1.0f);
        }
        if (scaledAmount.floatValue() > height) {
            scaledAmount.setValue(height);
        }
        ClientProxy.getFluidSpriteAndColor(fluid, (sprite, color) -> {
            if (sprite == null) {
                float maxY = yPosition + height;
                if (color == -1) {
                    color = -1431655766;
                }
                DisplayHelper.fill(guiGraphics, xPosition, maxY - scaledAmount.floatValue(), xPosition + width, maxY, color);
            } else {
                if (this.opacity() != 1.0f) {
                    color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
                }
                this.drawTiledSprite(guiGraphics, class_1921::method_62277, xPosition, yPosition, width, height, (int)color, scaledAmount.floatValue(), (class_1058)sprite);
            }
        });
    }

    private void drawTiledSprite(class_332 guiGraphics, Function<class_2960, class_1921> function, float xPosition, float yPosition, float tiledWidth, float tiledHeight, int color, float scaledAmount, class_1058 sprite) {
        if (tiledWidth == 0.0f || tiledHeight == 0.0f || scaledAmount == 0.0f) {
            return;
        }
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        class_4588 vertexConsumer = guiGraphics.field_44658.getBuffer(function.apply(sprite.method_45852()));
        int xTileCount = (int)(tiledWidth / 16.0f);
        float xRemainder = tiledWidth - (float)(xTileCount * 16);
        int yTileCount = (int)(scaledAmount / 16.0f);
        float yRemainder = scaledAmount - (float)(yTileCount * 16);
        float yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float width = xTile == xTileCount ? xRemainder : 16.0f;
                float height = yTile == yTileCount ? yRemainder : 16.0f;
                float x = xPosition + (float)(xTile * 16);
                float y = yStart - (float)((yTile + 1) * 16);
                if (!(width > 0.0f) || !(height > 0.0f)) continue;
                float maskTop = 16.0f - height;
                float maskRight = 16.0f - width;
                DisplayHelper.drawTextureWithMasking(matrix, vertexConsumer, x, y, sprite, maskTop, maskRight, 0.0f, color);
            }
        }
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli) {
        return this.humanReadableNumber(number, unit, milli, dfCommas);
    }

    @Override
    public String humanReadableNumber(double number, String unit, boolean milli, @Nullable Format formatter) {
        int exp;
        boolean n;
        if (class_3532.method_20390((double)number, (double)0.0)) {
            return "0" + unit;
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = n = number < 0.0;
        if (n) {
            number = -number;
            sb.append('-');
        }
        if (milli && number >= 1000.0) {
            number /= 1000.0;
            milli = false;
        }
        int n2 = exp = formatter == null && number < 10000.0 ? 0 : (int)Math.log10(number) / 3;
        if (exp > 7) {
            exp = 7;
        }
        if (exp > 0) {
            number /= Math.pow(1000.0, exp);
        }
        if (formatter == null) {
            formatter = number < 10.0 ? dfCommasArray[0] : (number < 100.0 ? dfCommasArray[1] : dfCommasArray[2]);
        }
        if (formatter instanceof NumberFormat) {
            NumberFormat numberFormat = (NumberFormat)formatter;
            sb.append(numberFormat.format(number));
        } else {
            sb.append(formatter.format(new Object[]{number}));
        }
        if (exp == 0) {
            if (milli) {
                sb.append('m');
            }
        } else {
            char pre = "kMGTPEZ".charAt(exp - 1);
            sb.append(pre);
        }
        sb.append(unit);
        return sb.toString();
    }

    @Override
    public void drawText(class_332 guiGraphics, String text, float x, float y, int color) {
        this.drawText(guiGraphics, (class_5348)class_2561.method_43470((String)text), x, y, color);
    }

    @Override
    public void drawText(class_332 guiGraphics, class_5348 text, float x, float y, int color) {
        class_5481 sequence;
        if (text instanceof class_2561) {
            class_2561 component = (class_2561)text;
            sequence = component.method_30937();
        } else {
            sequence = class_2477.method_10517().method_30934(text);
        }
        this.drawText(guiGraphics, sequence, x, y, color);
    }

    @Override
    public void drawText(class_332 guiGraphics, class_5481 text, float x, float y, int color) {
        boolean shadow = IWailaConfig.get().overlay().getTheme().text.shadow();
        if (this.opacity() != 1.0f) {
            color = IWailaConfig.Overlay.applyAlpha(color, this.opacity());
        }
        guiGraphics.method_51430(DisplayHelper.font(), text, (int)x, (int)y, color, shadow);
        guiGraphics.field_44658.method_37104();
    }

    public void drawGradientProgress(class_332 guiGraphics, float left, float top, float width, float height, float progress, int progressColor) {
        Color color = Color.rgb(progressColor);
        Color highlight = Color.hsl(color.getHue(), color.getSaturation(), Math.min(color.getLightness() + 0.2, 1.0), color.getOpacity());
        if (progress < 0.1f) {
            this.drawGradientRect(guiGraphics, left, top, width * progress, height, progressColor, highlight.toInt(), true);
        } else {
            float hlWidth = width * 0.1f;
            float normalWidth = width * progress - hlWidth;
            DisplayHelper.fill(guiGraphics, left, top, left + normalWidth, top + height, progressColor);
            this.drawGradientRect(guiGraphics, left + normalWidth, top, hlWidth, height, progressColor, highlight.toInt(), true);
        }
    }

    @Override
    public class_5250 stripColor(class_2561 component) {
        class_5250 mutableComponent = class_2561.method_43473();
        component.method_27658((style, string) -> {
            if (!string.isEmpty()) {
                class_5250 literal = class_2561.method_43470((String)STRIP_COLOR.matcher(string).replaceAll(""));
                literal.method_27696(style.method_27703((class_5251)null));
                mutableComponent.method_10852((class_2561)literal);
            }
            return Optional.empty();
        }, class_2583.field_24360);
        return mutableComponent;
    }

    @Override
    public void blitSprite(class_332 guiGraphics, Function<class_2960, class_1921> function, class_2960 resourceLocation, int i, int j, int k, int l) {
        guiGraphics.method_52707(class_1921::method_62277, resourceLocation, i, j, k, l, class_9848.method_61317((float)this.opacity()));
    }

    @Override
    public void blitSprite(class_332 guiGraphics, Function<class_2960, class_1921> function, class_2960 resourceLocation, int i, int j, int k, int l, int m) {
        guiGraphics.method_52707(class_1921::method_62277, resourceLocation, i, j, k, l, class_9848.method_61330((int)class_9848.method_61326((float)this.opacity()), (int)m));
    }

    @Override
    public void blitSprite(class_332 guiGraphics, Function<class_2960, class_1921> function, class_2960 resourceLocation, int i, int j, int k, int l, int m, int n, int o, int p) {
        guiGraphics.method_52708(class_1921::method_62277, resourceLocation, i, j, k, l, m, n, o, p);
    }

    @Override
    public float opacity() {
        return OverlayRenderer.alpha;
    }

    public static class_327 font() {
        return FONT.get();
    }

    static {
        for (DecimalFormat format : dfCommasArray) {
            format.setRoundingMode(RoundingMode.DOWN);
        }
    }
}

