/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.util.CommonProxy;

public final class UsernameCache {
    public static final Codec<Map<UUID, String>> CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, (Codec)class_5699.field_41759);
    private static final int CACHE_SIZE = 1024;
    private static final Object2ObjectLinkedOpenHashMap<UUID, String> map = new Object2ObjectLinkedOpenHashMap(1024);
    private static final Path saveFile = CommonProxy.getConfigDirectory().toPath().resolve("jade/usernamecache.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static boolean loading = false;

    private UsernameCache() {
    }

    public static void setUsername(UUID uuid, String username) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(username);
        if (!UsernameCache.isValidName(username)) {
            return;
        }
        if (map.size() >= 1024) {
            map.removeFirst();
        }
        String prev = (String)map.put((Object)uuid, (Object)username);
        if (!loading && !Objects.equals(prev, username)) {
            UsernameCache.save();
        }
    }

    public static boolean isValidName(String name) {
        return !name.isEmpty() && !name.contains("\u00a7");
    }

    public static boolean removeUsername(UUID uuid) {
        Objects.requireNonNull(uuid);
        if (map.remove((Object)uuid) != null) {
            UsernameCache.save();
            return true;
        }
        return false;
    }

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        Objects.requireNonNull(uuid);
        return (String)map.get((Object)uuid);
    }

    public static boolean containsUUID(UUID uuid) {
        Objects.requireNonNull(uuid);
        return map.containsKey((Object)uuid);
    }

    public static Map<UUID, String> getMap() {
        return Collections.unmodifiableMap(map);
    }

    public static void save() {
        try {
            new SaveThread(gson.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, map).getOrThrow())).start();
        }
        catch (Exception e) {
            Jade.LOGGER.error("Failed to save username cache to file!", (Throwable)e);
        }
    }

    public static void load() {
        if (!Files.exists(saveFile, new LinkOption[0])) {
            return;
        }
        loading = true;
        try (BufferedReader reader = Files.newBufferedReader(saveFile, StandardCharsets.UTF_8);){
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            Map tempMap = (Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            if (tempMap != null) {
                map.clear();
                tempMap.forEach(UsernameCache::setUsername);
            }
        }
        catch (Exception e) {
            Jade.LOGGER.error("Could not parse username cache file as valid json, deleting file %s".formatted(saveFile), (Throwable)e);
            try {
                Files.delete(saveFile);
            }
            catch (IOException e1) {
                Jade.LOGGER.error("Could not delete file %s".formatted(saveFile), (Throwable)e1);
            }
        }
        finally {
            loading = false;
        }
    }

    private static class SaveThread
    extends Thread {
        private final String data;

        public SaveThread(String data) {
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Path path = saveFile;
                synchronized (path) {
                    Files.writeString(saveFile, (CharSequence)this.data, StandardCharsets.UTF_8, new OpenOption[0]);
                }
            }
            catch (IOException e) {
                Jade.LOGGER.error("Failed to save username cache to file!");
            }
        }
    }
}

