/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4239;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_640;
import net.minecraft.class_8685;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.ETFException;
import traben.entity_texture_features.config.screens.skin.ETFScreenOldCompat;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolOutcome
extends ETFScreenOldCompat {
    private final boolean didSucceed;
    private final class_1011 skin;

    protected ETFConfigScreenSkinToolOutcome(class_437 parent, boolean success, class_1011 skin) {
        super("config.entity_texture_features.player_skin_editor.print_skin.result", parent, false);
        this.didSucceed = success;
        this.skin = skin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean uploadSkin(boolean skinType) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            if ("127.0.0.1".equals(InetAddress.getLocalHost().getHostAddress())) {
                boolean bl2 = false;
                return bl2;
            }
            String auth = class_310.method_1551().method_1548().method_1674();
            HttpPost http = new HttpPost("https://api.minecraftservices.com/minecraft/profile/skins");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("variant", skinType ? "classic" : "slim", ContentType.TEXT_PLAIN);
            assert (ETF.getConfigDirectory() != null);
            builder.addBinaryBody("file", (InputStream)new FileInputStream(Path.of(ETF.getConfigDirectory().toFile().getParent(), "\\ETF_player_skin_printout.png").toFile()), ContentType.IMAGE_PNG, "skin.png");
            http.setEntity(builder.build());
            http.addHeader("Authorization", "Bearer " + auth);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)http);
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.55), (int)((double)this.field_22790 * 0.9), (int)((double)this.field_22789 * 0.2), 20, class_5244.field_24334, button -> Objects.requireNonNull(this.field_22787).method_1507(this.parent)));
        if (this.didSucceed) {
            this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.15), (int)((double)this.field_22790 * 0.6), (int)((double)this.field_22789 * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.open"), button -> {
                try {
                    assert (ETF.getConfigDirectory() != null);
                    Path outputDirectory = Path.of(ETF.getConfigDirectory().toFile().getParent(), new String[0]);
                    class_156.method_668().method_672(outputDirectory.toFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.15), (int)((double)this.field_22790 * 0.4), (int)((double)this.field_22789 * 0.7), 20, ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin"), button -> {
                boolean changeSuccess;
                class_640 playerListEntry;
                if (class_310.method_1551().field_1724 == null) {
                    return;
                }
                boolean skinType = true;
                if (class_310.method_1551().method_1562() != null && (playerListEntry = class_310.method_1551().method_1562().method_2871(class_310.method_1551().field_1724.method_5667())) != null) {
                    skinType = class_310.method_1551().method_1582().method_52862(playerListEntry.method_2966()).comp_1629() == class_8685.class_7920.field_41123;
                }
                button.method_25355(ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.upload_skin_v2." + ((changeSuccess = ETFConfigScreenSkinToolOutcome.uploadSkin(skinType)) ? "success" : "fail")));
                if (changeSuccess) {
                    try {
                        GameProfile gameProfile = class_310.method_1551().field_1724.method_7334();
                        MinecraftProfileTexture minecraftProfileTexture = class_310.method_1551().method_1582().field_46910.getTextures(gameProfile).skin();
                        if (minecraftProfileTexture == null) {
                            throw new ETFException("No profile texture found for player: " + gameProfile.getName());
                        }
                        String string = Hashing.sha1().hashUnencodedChars((CharSequence)minecraftProfileTexture.getHash()).toString();
                        Path path = class_310.method_1551().method_1582().field_45635.field_45640.resolve(string.length() > 2 ? string.substring(0, 2) : "xx").resolve(string);
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            class_4239.method_47525((Path)path.getParent());
                            this.skin.method_4314(path);
                        }
                    }
                    catch (Exception e) {
                        ETFUtils2.logError("Failed to change in-game skin correctly, you might need to restart to see all the uploaded changes in-game", true);
                        ETFUtils2.logError("cause: " + e.getMessage(), false);
                    }
                    class_1044 texture = class_310.method_1551().method_1531().method_4619(class_310.method_1551().field_1724.method_52814().comp_1626());
                    if (texture instanceof class_1043) {
                        class_1043 dynamicTexture = (class_1043)texture;
                        dynamicTexture.method_4526(this.skin);
                    }
                    if (class_310.method_1551().field_1724 != null) {
                        ETFManager.getInstance().PLAYER_TEXTURE_MAP.removeEntryOnly(class_310.method_1551().field_1724.method_5667());
                    }
                } else {
                    ETFUtils2.logError("Failed to change in-game skin correctly, you might need to restart to see all the uploaded changes in-game", true);
                }
                button.field_22763 = false;
            }));
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        String[] strings = ETF.getTextFromTranslation("config.entity_texture_features.player_skin_editor.print_skin.result." + (this.didSucceed ? "success" : "fail")).getString().split("\n");
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (String str : strings) {
            lines.add(class_2561.method_30163((String)str.strip()));
        }
        int i = 0;
        for (class_2561 txt : lines) {
            context.method_35719(this.field_22793, txt.method_30937(), (int)((double)this.field_22789 * 0.5), (int)((double)this.field_22790 * 0.3) + i, 0xFFFFFF);
            i += txt.getString().isBlank() ? 5 : 10;
        }
    }
}

