/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.Map;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.CarpetedBlock;
import juuxel.adorn.block.FluidUtil;
import juuxel.adorn.block.property.OptionalProperty;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.util.Shapes;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public final class ChairBlock
extends CarpetedBlock
implements class_3737,
BlockWithDescription {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final String DESCRIPTION_KEY = "block.adorn.chair.description";
    private static final Map<class_2350, class_265> LOWER_SHAPES;
    private static final Map<class_2350, class_265> LOWER_SHAPES_WITH_CARPET;
    private static final Map<class_2350, class_265> UPPER_OUTLINE_SHAPES;

    public ChairBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public class_2960 getSittingStat() {
        return AdornStats.SIT_ON_CHAIR;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, HALF, WATERLOGGED});
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        if (pos.method_10264() < world.method_31600() && world.method_8320(pos.method_10084()).method_26166(ctx)) {
            return (class_2680)((class_2680)super.method_9605(ctx).method_11657(FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910));
        }
        return null;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            class_2680 downState = world.method_8320(pos.method_10074());
            return downState.method_26204() == this && downState.method_11654(HALF) == class_2756.field_12607;
        }
        return super.method_9558(state, world, pos);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.field_9236 && player.method_68878()) {
            class_2320.method_30036((class_1937)world, (class_2338)pos, (class_2680)state, (class_1657)player);
        }
        return super.method_9576(world, pos, state, player);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        world.method_8501(pos.method_10084(), FluidUtil.updateFluidFromState((class_2680)((class_2680)this.method_9564().method_11657(HALF, (Comparable)class_2756.field_12609)).method_11657(FACING, (Comparable)((class_2350)state.method_11654(FACING))), world.method_8316(pos.method_10084())));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(HALF) == class_2756.field_12607) {
            if (this.isCarpetingEnabled() && ((OptionalProperty.Value)state.method_11654((class_2769)CARPET)).isPresent()) {
                return LOWER_SHAPES_WITH_CARPET.get(state.method_11654(FACING));
            }
            return LOWER_SHAPES.get(state.method_11654(FACING));
        }
        return UPPER_OUTLINE_SHAPES.get(state.method_11654(FACING));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(HALF) == class_2756.field_12607) {
            if (this.isCarpetingEnabled() && ((OptionalProperty.Value)state.method_11654((class_2769)CARPET)).isPresent()) {
                return LOWER_SHAPES_WITH_CARPET.get(state.method_11654(FACING));
            }
            return LOWER_SHAPES.get(state.method_11654(FACING));
        }
        return class_259.method_1073();
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        class_2756 half = (class_2756)state.method_11654(HALF);
        if (direction.method_10166() == class_2350.class_2351.field_11052 && half == class_2756.field_12607 == (direction == class_2350.field_11036)) {
            if (neighborState.method_26204() != this) {
                return class_2246.field_10124.method_9564();
            }
            return (class_2680)state.method_11657(FACING, (Comparable)((class_2350)neighborState.method_11654(FACING)));
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected class_2338 getActualSeatPos(class_1937 world, class_2680 state, class_2338 pos) {
        return switch ((class_2756)state.method_11654(HALF)) {
            default -> throw new MatchException(null, null);
            case class_2756.field_12609 -> pos.method_10074();
            case class_2756.field_12607 -> pos;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    @Override
    public boolean canStateBeCarpeted(class_2680 state) {
        return super.canStateBeCarpeted(state) && state.method_11654(HALF) == class_2756.field_12607;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    @Override
    public double getSittingOffset(class_1937 world, class_2680 state, class_2338 pos) {
        return 0.625;
    }

    @Override
    public class_2350 getPreferredDismountDirection(class_2680 state, class_1297 passenger) {
        return (class_2350)state.method_11654(FACING);
    }

    static {
        class_265 lowerSeatShape = class_259.method_17786((class_265)ChairBlock.method_9541((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), (class_265[])new class_265[]{ChairBlock.method_9541((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0), ChairBlock.method_9541((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0), ChairBlock.method_9541((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0), ChairBlock.method_9541((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0)});
        Map<class_2350, class_265> lowerBackShapes = Shapes.buildShapeRotations(2, 10, 2, 4, 24, 14);
        LOWER_SHAPES = Shapes.mergeIntoShapeMap(lowerBackShapes, lowerSeatShape);
        LOWER_SHAPES_WITH_CARPET = Shapes.mergeIntoShapeMap(LOWER_SHAPES, CARPET_SHAPE);
        class_265 upperSeatShape = class_259.method_17786((class_265)ChairBlock.method_9541((double)2.0, (double)-8.0, (double)2.0, (double)14.0, (double)-6.0, (double)14.0), (class_265[])new class_265[]{ChairBlock.method_9541((double)2.0, (double)-16.0, (double)2.0, (double)4.0, (double)-8.0, (double)4.0), ChairBlock.method_9541((double)12.0, (double)-16.0, (double)2.0, (double)14.0, (double)-8.0, (double)4.0), ChairBlock.method_9541((double)2.0, (double)-16.0, (double)12.0, (double)4.0, (double)-8.0, (double)14.0), ChairBlock.method_9541((double)12.0, (double)-16.0, (double)12.0, (double)14.0, (double)-8.0, (double)14.0)});
        Map<class_2350, class_265> upperBackShapes = Shapes.buildShapeRotations(2, -6, 2, 4, 8, 14);
        UPPER_OUTLINE_SHAPES = Shapes.mergeIntoShapeMap(upperBackShapes, upperSeatShape);
    }
}

