/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import java.util.Objects;
import java.util.UUID;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.entity.TradingStation;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.lib.AdornGameRules;
import juuxel.adorn.menu.TradingStationMenu;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.trading.TradeOwner;
import juuxel.adorn.util.AdornUtil;
import juuxel.adorn.util.InventoryComponent;
import juuxel.adorn.util.NbtUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public final class TradingStationBlockEntity
extends class_2586
implements class_3908,
TradingStation {
    public static final int STORAGE_SIZE = 12;
    public static final String NBT_TRADING_OWNER = "TradingOwner";
    public static final String NBT_TRADING_OWNER_NAME = "TradingOwnerName";
    public static final String NBT_TRADE = "Trade";
    public static final String NBT_STORAGE = "Storage";
    public static final class_2561 UNKNOWN_OWNER = class_2561.method_43470((String)"???");
    @Nullable
    private UUID owner = null;
    private class_2561 ownerName = UNKNOWN_OWNER;
    private final Trade trade = Trade.empty();
    private final InventoryComponent storage = new InventoryComponent(12);

    public TradingStationBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)AdornBlockEntities.TRADING_STATION.get(), pos, state);
        this.trade.addListener(sender -> this.method_5431());
        this.storage.addListener(sender -> this.method_5431());
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    public void setOwner(class_1657 player) {
        this.owner = player.method_7334().getId();
        this.ownerName = class_2561.method_43470((String)player.method_7334().getName());
        this.method_5431();
    }

    public void setOwnerIfMissing(class_1657 player) {
        if (this.owner == null) {
            this.setOwner(player);
        }
    }

    public boolean isStorageStocked() {
        return this.storage.getCountWithComponents(this.trade.getSelling()) >= this.trade.getSelling().method_7947();
    }

    public boolean isOwner(class_1657 player) {
        return player.method_7334().getId().equals(this.owner);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new TradingStationMenu(syncId, playerInventory, AdornUtil.menuContextOf(this));
    }

    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    @Override
    public class_2561 getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(class_2561 ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public Trade getTrade() {
        return this.trade;
    }

    @Override
    public InventoryComponent getStorage() {
        return this.storage;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.owner = nbt.method_67491(NBT_TRADING_OWNER, class_4844.field_25122).orElse(null);
        this.ownerName = Objects.requireNonNullElse(NbtUtil.getText(nbt, NBT_TRADING_OWNER_NAME, registries), UNKNOWN_OWNER);
        this.trade.readNbt(nbt.method_68568(NBT_TRADE), registries);
        this.storage.readNbt(nbt.method_68568(NBT_STORAGE), registries);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_68082(NBT_TRADING_OWNER, class_4844.field_25122, (Object)this.owner);
        NbtUtil.putText(nbt, NBT_TRADING_OWNER_NAME, this.ownerName, registries);
        nbt.method_10566(NBT_TRADE, (class_2520)this.trade.writeNbt(new class_2487(), registries));
        nbt.method_10566(NBT_STORAGE, (class_2520)this.storage.writeNbt(new class_2487(), registries));
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_58692(registries);
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        this.trade.copyFrom((Trade)components.method_58694((class_9331)AdornComponentTypes.TRADE.get()));
        this.storage.copyFrom((class_9288)components.method_58694(class_9334.field_49622));
        TradeOwner owner = (TradeOwner)components.method_58694((class_9331)AdornComponentTypes.TRADE_OWNER.get());
        if (owner != null) {
            this.owner = owner.uuid();
            this.ownerName = owner.name();
        }
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840((class_9331)AdornComponentTypes.TRADE.get(), (Object)this.trade);
        builder.method_57840(class_9334.field_49622, (Object)this.storage.toContainerComponent());
        if (this.owner != null) {
            builder.method_57840((class_9331)AdornComponentTypes.TRADE_OWNER.get(), (Object)new TradeOwner(this.owner, this.ownerName));
        }
    }

    public void method_57569(class_2487 nbt) {
        super.method_57569(nbt);
        nbt.method_10551(NBT_TRADE);
        nbt.method_10551(NBT_STORAGE);
        nbt.method_10551(NBT_TRADING_OWNER);
        nbt.method_10551(NBT_TRADING_OWNER_NAME);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        class_3218 serverWorld;
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218 && !(serverWorld = (class_3218)class_19372).method_64395().method_8355(AdornGameRules.DROP_LOCKED_TRADING_STATIONS)) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.getStorage());
        }
    }
}

