/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.variant;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.lib.registry.RegistryHelper;
import juuxel.adorn.util.AdornUtil;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public interface BlockVariant
extends RegistryHelper.BlockSettingsProvider {
    public static final char MOD_ID_SEPARATOR = '/';
    public static final Map<class_1767, BlockVariant> WOOLS = BlockVariant.createBy((Enum[])class_1767.values(), (T color) -> BlockVariant.variant(color.method_15434(), class_2246.field_10446));
    public static final Map<class_1767, BlockVariant> PAINTED_WOODS = BlockVariant.createBy((Enum[])class_1767.values(), PaintedWood::new);
    public static final BlockVariant IRON = BlockVariant.variant("iron", class_2246.field_10576);
    public static final BlockVariant OAK = BlockVariant.variant("oak", class_2246.field_10161);
    public static final BlockVariant SPRUCE = BlockVariant.variant("spruce", class_2246.field_9975);
    public static final BlockVariant BIRCH = BlockVariant.variant("birch", class_2246.field_10148);
    public static final BlockVariant JUNGLE = BlockVariant.variant("jungle", class_2246.field_10334);
    public static final BlockVariant ACACIA = BlockVariant.variant("acacia", class_2246.field_10218);
    public static final BlockVariant DARK_OAK = BlockVariant.variant("dark_oak", class_2246.field_10075);
    public static final BlockVariant MANGROVE = BlockVariant.variant("mangrove", class_2246.field_37577);
    public static final BlockVariant CHERRY = BlockVariant.variant("cherry", class_2246.field_42751);
    public static final BlockVariant PALE_OAK = BlockVariant.variant("pale_oak", class_2246.field_54735);
    public static final BlockVariant BAMBOO = BlockVariant.variant("bamboo", class_2246.field_40294);
    public static final BlockVariant CRIMSON = BlockVariant.variant("crimson", class_2246.field_22126);
    public static final BlockVariant WARPED = BlockVariant.variant("warped", class_2246.field_22127);
    public static final BlockVariant STONE = BlockVariant.variant("stone", class_2246.field_10340);
    public static final BlockVariant COBBLESTONE = BlockVariant.variant("cobblestone", class_2246.field_10445);
    public static final BlockVariant SANDSTONE = BlockVariant.variant("sandstone", class_2246.field_9979);
    public static final BlockVariant DIORITE = BlockVariant.variant("diorite", class_2246.field_10508);
    public static final BlockVariant ANDESITE = BlockVariant.variant("andesite", class_2246.field_10115);
    public static final BlockVariant GRANITE = BlockVariant.variant("granite", class_2246.field_10474);
    public static final BlockVariant BRICK = BlockVariant.variant("brick", class_2246.field_10104);
    public static final BlockVariant STONE_BRICK = BlockVariant.variant("stone_brick", class_2246.field_10056);
    public static final BlockVariant RED_SANDSTONE = BlockVariant.variant("red_sandstone", class_2246.field_10344);
    public static final BlockVariant NETHER_BRICK = BlockVariant.variant("nether_brick", class_2246.field_10266);
    public static final BlockVariant BASALT = BlockVariant.variant("basalt", class_2246.field_22091);
    public static final BlockVariant BLACKSTONE = BlockVariant.variant("blackstone", class_2246.field_23869);
    public static final BlockVariant RED_NETHER_BRICK = BlockVariant.variant("red_nether_brick", class_2246.field_9986);
    public static final BlockVariant PRISMARINE = BlockVariant.variant("prismarine", class_2246.field_10135);
    public static final BlockVariant QUARTZ = BlockVariant.variant("quartz", class_2246.field_10153);
    public static final BlockVariant END_STONE_BRICK = BlockVariant.variant("end_stone_brick", class_2246.field_10462);
    public static final BlockVariant PURPUR = BlockVariant.variant("purpur", class_2246.field_10286);
    public static final BlockVariant POLISHED_BLACKSTONE = BlockVariant.variant("polished_blackstone", class_2246.field_23873);
    public static final BlockVariant POLISHED_BLACKSTONE_BRICK = BlockVariant.variant("polished_blackstone_brick", class_2246.field_23874);
    public static final BlockVariant POLISHED_DIORITE = BlockVariant.variant("polished_diorite", class_2246.field_10346);
    public static final BlockVariant POLISHED_ANDESITE = BlockVariant.variant("polished_andesite", class_2246.field_10093);
    public static final BlockVariant POLISHED_GRANITE = BlockVariant.variant("polished_granite", class_2246.field_10289);
    public static final BlockVariant PRISMARINE_BRICK = BlockVariant.variant("prismarine_brick", class_2246.field_10006);
    public static final BlockVariant DARK_PRISMARINE = BlockVariant.variant("dark_prismarine", class_2246.field_10297);
    public static final BlockVariant CUT_SANDSTONE = BlockVariant.variant("cut_sandstone", class_2246.field_10361);
    public static final BlockVariant SMOOTH_SANDSTONE = BlockVariant.variant("smooth_sandstone", class_2246.field_10467);
    public static final BlockVariant CUT_RED_SANDSTONE = BlockVariant.variant("cut_red_sandstone", class_2246.field_10518);
    public static final BlockVariant SMOOTH_RED_SANDSTONE = BlockVariant.variant("smooth_red_sandstone", class_2246.field_10483);
    public static final BlockVariant SMOOTH_STONE = BlockVariant.variant("smooth_stone", class_2246.field_10360);
    public static final BlockVariant MOSSY_COBBLESTONE = BlockVariant.variant("mossy_cobblestone", class_2246.field_9989);
    public static final BlockVariant MOSSY_STONE_BRICK = BlockVariant.variant("mossy_stone_brick", class_2246.field_10065);
    public static final BlockVariant DEEPSLATE = BlockVariant.variant("deepslate", class_2246.field_28888);
    public static final BlockVariant COBBLED_DEEPSLATE = BlockVariant.variant("cobbled_deepslate", class_2246.field_29031);
    public static final BlockVariant POLISHED_DEEPSLATE = BlockVariant.variant("polished_deepslate", class_2246.field_28892);
    public static final BlockVariant DEEPSLATE_BRICK = BlockVariant.variant("deepslate_brick", class_2246.field_28900);
    public static final BlockVariant DEEPSLATE_TILE = BlockVariant.variant("deepslate_tile", class_2246.field_28896);
    public static final BlockVariant TUFF = BlockVariant.variant("tuff", class_2246.field_27165);
    public static final BlockVariant POLISHED_TUFF = BlockVariant.variant("polished_tuff", class_2246.field_47030);
    public static final BlockVariant TUFF_BRICK = BlockVariant.variant("tuff_brick", class_2246.field_47035);
    public static final BlockVariant RESIN_BRICK = BlockVariant.variant("resin_brick", class_2246.field_55054);

    public String name();

    default public class_2960 nameAsIdentifier() {
        String name = this.name();
        return class_2960.method_12838((String)name, (char)'/');
    }

    @Override
    public class_4970.class_2251 createBlockSettings();

    public static BlockVariant variant(final String name, final class_2248 base) {
        return new BlockVariant(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public class_4970.class_2251 createBlockSettings() {
                return AdornUtil.copySettingsSafely(base);
            }
        };
    }

    public static BlockVariant wool(class_1767 color) {
        return WOOLS.get(color);
    }

    private static <K extends Enum<K>> Map<K, BlockVariant> createBy(K[] keys, Function<K, BlockVariant> factory) {
        Class<?> keyType = keys[0].getClass();
        return Collections.unmodifiableMap(Arrays.stream(keys).map(key -> Pair.of((Object)key, (Object)((BlockVariant)factory.apply(key)))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> a, () -> new EnumMap(keyType))));
    }

    public record PaintedWood(class_1767 color) implements BlockVariant
    {
        @Override
        public String name() {
            return this.color.method_7792();
        }

        @Override
        public class_2960 nameAsIdentifier() {
            return AdornCommon.id(this.name());
        }

        @Override
        public class_4970.class_2251 createBlockSettings() {
            return AdornUtil.copySettingsSafely(AdornBlocks.PAINTED_PLANKS.getEager(this.color));
        }
    }

    public record Stone(String name) implements BlockVariant
    {
        @Override
        public class_4970.class_2251 createBlockSettings() {
            return AdornUtil.copySettingsSafely(class_2246.field_10445);
        }
    }

    public record Wood(String name) implements BlockVariant
    {
        @Override
        public class_4970.class_2251 createBlockSettings() {
            return AdornUtil.copySettingsSafely(class_2246.field_10161);
        }
    }
}

