/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.variant;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import juuxel.adorn.block.BenchBlock;
import juuxel.adorn.block.ChairBlock;
import juuxel.adorn.block.CoffeeTableBlock;
import juuxel.adorn.block.DrawerBlock;
import juuxel.adorn.block.KitchenCounterBlock;
import juuxel.adorn.block.KitchenCupboardBlock;
import juuxel.adorn.block.KitchenSinkBlock;
import juuxel.adorn.block.PlatformBlock;
import juuxel.adorn.block.PostBlock;
import juuxel.adorn.block.ShelfBlock;
import juuxel.adorn.block.StepBlock;
import juuxel.adorn.block.TableBlock;
import juuxel.adorn.block.variant.BlockKind;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.block.variant.BlockVariantSet;
import juuxel.adorn.block.variant.CompatBlockVariantSet;
import juuxel.adorn.block.variant.MinecraftBlockVariants;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.item.ChairBlockItem;
import juuxel.adorn.item.TableBlockItem;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.lib.registry.RegistrarFactory;
import juuxel.adorn.lib.registry.RegistryHelper;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class BlockVariantSets {
    public static final Registrar<class_2248> BLOCKS = RegistrarFactory.get().create(class_7924.field_41254);
    public static final Registrar<class_1792> ITEMS = RegistrarFactory.get().create(class_7924.field_41197);
    private static final RegistryHelper HELPER = new RegistryHelper(BLOCKS, ITEMS);
    private static final List<BlockVariantSet> variantSets = new ArrayList<BlockVariantSet>();
    private static final ListMultimap<BlockKind, Registered<class_2248>> blocksByKind = MultimapBuilder.enumKeys(BlockKind.class).arrayListValues().build();
    private static final ListMultimap<BlockVariant, Registered<class_2248>> blocksByVariant = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    private static final Map<Pair<BlockKind, BlockVariant>, Registered<class_2248>> blocksByKindVariant = new LinkedHashMap<Pair<BlockKind, BlockVariant>, Registered<class_2248>>();

    public static Set<BlockVariant> allVariants() {
        ArrayList variants = new ArrayList(blocksByVariant.keySet());
        BlockVariantSet.Sorter sorter = (variant, after) -> {
            variants.remove(variant);
            variants.add(variants.indexOf(after) + 1, variant);
        };
        for (BlockVariantSet variantSet : variantSets) {
            variantSet.sortVariants(sorter);
        }
        return new LinkedHashSet<BlockVariant>(variants);
    }

    public static void add(BlockVariantSet variantSet) {
        variantSets.add(variantSet);
    }

    public static void loadCompatSets() {
        for (CompatBlockVariantSet set : ServiceLoader.load(CompatBlockVariantSet.class)) {
            if (!ConfigManager.isCompatEnabled(set.getModId())) continue;
            BlockVariantSets.add(set);
        }
    }

    public static List<Registered<class_2248>> get(BlockKind kind) {
        return blocksByKind.get((Object)kind);
    }

    @Nullable
    public static Registered<class_2248> get(BlockKind kind, BlockVariant variant) {
        return blocksByKindVariant.get(Pair.of((Object)((Object)kind), (Object)variant));
    }

    public static void register() {
        List<BlockVariant> woodVariants = variantSets.stream().flatMap(set -> set.getWoodVariants().stream()).toList();
        List stoneVariants = variantSets.stream().flatMap(set -> set.getStoneVariants().stream()).toList();
        ArrayList<BlockVariant> allVariants = new ArrayList<BlockVariant>(woodVariants.size() + stoneVariants.size());
        allVariants.addAll(woodVariants);
        allVariants.addAll(stoneVariants);
        BlockVariantSets.register(BlockKind.CHAIR, woodVariants);
        BlockVariantSets.register(BlockKind.TABLE, woodVariants);
        BlockVariantSets.register(BlockKind.DRAWER, woodVariants);
        BlockVariantSets.register(BlockKind.KITCHEN_COUNTER, woodVariants);
        BlockVariantSets.register(BlockKind.KITCHEN_CUPBOARD, woodVariants);
        BlockVariantSets.register(BlockKind.KITCHEN_SINK, woodVariants);
        BlockVariantSets.register(BlockKind.POST, allVariants);
        BlockVariantSets.register(BlockKind.PLATFORM, allVariants);
        BlockVariantSets.register(BlockKind.STEP, allVariants);
        BlockVariantSets.register(BlockKind.SHELF, woodVariants);
        BlockVariantSets.register(BlockKind.COFFEE_TABLE, woodVariants);
        BlockVariantSets.register(BlockKind.BENCH, woodVariants);
        for (BlockVariantSet set2 : variantSets) {
            set2.addVariants((variant, kinds) -> {
                for (BlockKind kind : kinds) {
                    BlockVariantSets.register(kind, variant);
                }
            });
        }
    }

    private static void register(BlockKind kind, List<BlockVariant> variants) {
        for (BlockVariant variant : variants) {
            BlockVariantSets.register(kind, variant);
        }
    }

    private static void register(BlockKind kind, BlockVariant variant) {
        Registered<class_2248> registered = switch (kind) {
            default -> throw new MatchException(null, null);
            case BlockKind.CHAIR -> BlockVariantSets.registerChair(variant);
            case BlockKind.TABLE -> BlockVariantSets.registerTable(variant);
            case BlockKind.DRAWER -> BlockVariantSets.registerDrawer(variant);
            case BlockKind.KITCHEN_COUNTER -> BlockVariantSets.registerKitchenCounter(variant);
            case BlockKind.KITCHEN_CUPBOARD -> BlockVariantSets.registerKitchenCupboard(variant);
            case BlockKind.KITCHEN_SINK -> BlockVariantSets.registerKitchenSink(variant);
            case BlockKind.POST -> BlockVariantSets.registerPost(variant);
            case BlockKind.PLATFORM -> BlockVariantSets.registerPlatform(variant);
            case BlockKind.STEP -> BlockVariantSets.registerStep(variant);
            case BlockKind.SHELF -> BlockVariantSets.registerShelf(variant);
            case BlockKind.COFFEE_TABLE -> BlockVariantSets.registerCoffeeTable(variant);
            case BlockKind.BENCH -> BlockVariantSets.registerBench(variant);
        };
        blocksByKind.put((Object)kind, registered);
        blocksByVariant.put((Object)variant, registered);
        blocksByKindVariant.put((Pair<BlockKind, BlockVariant>)Pair.of((Object)((Object)kind), (Object)variant), registered);
    }

    private static Registered<class_2248> registerPost(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_post", PostBlock::new, variant);
    }

    private static Registered<class_2248> registerPlatform(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_platform", PlatformBlock::new, variant);
    }

    private static Registered<class_2248> registerStep(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_step", StepBlock::new, variant);
    }

    private static Registered<class_2248> registerDrawer(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_drawer", DrawerBlock::new, variant);
    }

    private static Registered<class_2248> registerChair(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_chair", ChairBlockItem::new, ChairBlock::new, (RegistryHelper.BlockSettingsProvider)variant);
    }

    private static Registered<class_2248> registerTable(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_table", TableBlockItem::new, TableBlock::new, (RegistryHelper.BlockSettingsProvider)variant);
    }

    private static Registered<class_2248> registerKitchenCounter(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_kitchen_counter", KitchenCounterBlock::new, variant);
    }

    private static Registered<class_2248> registerKitchenCupboard(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_kitchen_cupboard", KitchenCupboardBlock::new, variant);
    }

    private static Registered<class_2248> registerKitchenSink(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_kitchen_sink", KitchenSinkBlock::new, variant);
    }

    private static Registered<class_2248> registerShelf(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_shelf", ShelfBlock::new, variant);
    }

    private static Registered<class_2248> registerCoffeeTable(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_coffee_table", CoffeeTableBlock::new, variant);
    }

    private static Registered<class_2248> registerBench(BlockVariant variant) {
        return HELPER.registerBlock(variant.name() + "_bench", BenchBlock::new, variant);
    }

    static {
        variantSets.add(new MinecraftBlockVariants());
    }
}

