/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import juuxel.adorn.block.AbstractKitchenCounterBlock;
import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.util.Logging;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.slf4j.Logger;

public abstract class KitchenSinkRenderer<T extends KitchenSinkBlockEntity>
implements class_827<T> {
    private static final Logger LOGGER = Logging.logger();
    private static final float PX = 0.0625f;
    private static final float X_START = 0.125f;
    private static final float X_END = 0.8125f;
    private static final float Z_START = 0.125f;
    private static final float Z_END = 0.875f;
    private static final float Y_START = 0.4375f;
    private static final float Y_END = 0.9375f;
    private static final double LITRES_PER_BLOCK = 1000.0;
    private static final float WAVE_PERIOD = 12000.0f;
    private static final float WAVE_HEIGHT = 0.0625f;
    private static final float MS_PER_TICK = 50.0f;

    private static float getRotation(class_2350 facing) {
        return switch (facing) {
            case class_2350.field_11034 -> 0.0f;
            case class_2350.field_11043 -> 90.0f;
            case class_2350.field_11039 -> 180.0f;
            case class_2350.field_11035 -> 270.0f;
            default -> 0.0f;
        };
    }

    protected KitchenSinkRenderer(class_5614.class_5615 context) {
    }

    public void render(T entity, float tickProgress, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_243 cameraPos) {
        if (this.isEmpty(entity)) {
            return;
        }
        class_1058 sprite = this.getFluidSprite(entity);
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)sprite.method_45852()));
        float u0 = class_3532.method_16439((float)0.125f, (float)sprite.method_4594(), (float)sprite.method_4577());
        float u1 = class_3532.method_16439((float)0.875f, (float)sprite.method_4594(), (float)sprite.method_4577());
        float v0 = class_3532.method_16439((float)0.125f, (float)sprite.method_4593(), (float)sprite.method_4575());
        float v1 = class_3532.method_16439((float)0.8125f, (float)sprite.method_4593(), (float)sprite.method_4575());
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(KitchenSinkRenderer.getRotation((class_2350)entity.method_11010().method_11654(AbstractKitchenCounterBlock.FACING))));
        matrices.method_22904(-0.5, 0.0, -0.5);
        double fluidLevel = this.getFluidLevel(entity) / 1000.0;
        matrices.method_22904(0.0, class_3532.method_16436((double)fluidLevel, (double)0.4375, (double)0.9375), 0.0);
        class_4587.class_4665 matrixEntry = matrices.method_23760();
        Matrix4f positionMatrix = matrixEntry.method_23761();
        int color = this.getFluidColor(entity);
        buffer.method_22918(positionMatrix, 0.125f, KitchenSinkRenderer.computeY(0.125f, 0.875f), 0.875f).method_39415(color).method_22913(u0, v0).method_22922(overlay).method_60803(light).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
        buffer.method_22918(positionMatrix, 0.8125f, KitchenSinkRenderer.computeY(0.8125f, 0.875f), 0.875f).method_39415(color).method_22913(u0, v1).method_22922(overlay).method_60803(light).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
        buffer.method_22918(positionMatrix, 0.8125f, KitchenSinkRenderer.computeY(0.8125f, 0.125f), 0.125f).method_39415(color).method_22913(u1, v1).method_22922(overlay).method_60803(light).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
        buffer.method_22918(positionMatrix, 0.125f, KitchenSinkRenderer.computeY(0.125f, 0.125f), 0.125f).method_39415(color).method_22913(u1, v0).method_22922(overlay).method_60803(light).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
        matrices.method_22909();
    }

    private static float computeY(float x, float z) {
        float time = (float)class_310.method_1551().field_1724.field_6012 * 50.0f % 12000.0f;
        float t = time * ((float)Math.PI * 2) / 12000.0f;
        return class_3532.method_15374((float)(t + x + z)) * 0.0625f / 2.0f;
    }

    private class_1058 getFluidSprite(T entity) {
        class_1058 sprite = FluidRenderingBridge.get().getStillSprite(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference());
        if (sprite == null) {
            LOGGER.error("Could not find sprite for fluid reference {} when rendering kitchen sink at {}", (Object)((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (Object)entity.method_11016());
            return (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(class_1047.method_4539());
        }
        return sprite;
    }

    private int getFluidColor(T entity) {
        return FluidRenderingBridge.get().getColor(((KitchenSinkBlockEntity)((Object)entity)).getFluidReference(), (class_1920)entity.method_10997(), entity.method_11016());
    }

    protected abstract double getFluidLevel(T var1);

    protected abstract boolean isEmpty(T var1);
}

