/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.AdornUtil;
import juuxel.adorn.util.Colors;
import net.minecraft.class_124;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public final class TradingStationRenderer
implements class_827<TradingStationBlockEntity> {
    private static final float SELLING_ROTATION_MULTIPLIER = 1.2f;
    private static final String OWNER_LABEL = "block.adorn.trading_station.label.owner";
    private static final String SELLING_LABEL = "block.adorn.trading_station.label.selling";
    private static final String PRICE_LABEL = "block.adorn.trading_station.label.price";
    private final class_824 dispatcher;
    private final class_327 textRenderer;

    public TradingStationRenderer(class_5614.class_5615 context) {
        this.dispatcher = context.method_32139();
        this.textRenderer = context.method_32143();
    }

    public void render(TradingStationBlockEntity be, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_243 cameraPos) {
        class_239 hitResult = this.dispatcher.field_4350;
        boolean lookingAtBlock = hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332 && be.method_11016().equals((Object)((class_3965)hitResult).method_17777());
        Trade trade = be.getTrade();
        if (!trade.isEmpty()) {
            matrices.method_22903();
            matrices.method_22904(0.5, 1.2, 0.5);
            int playerAge = class_310.method_1551().field_1724.field_6012;
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(((float)playerAge + tickDelta) * 1.2f));
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            matrices.method_22904(0.0, 0.3, 0.0);
            class_918 itemRenderer = class_310.method_1551().method_1480();
            itemRenderer.method_23178(trade.getSelling(), class_811.field_4319, light, overlay, matrices, vertexConsumers, be.method_10997(), 0);
            matrices.method_22909();
        }
        if (lookingAtBlock && ConfigManager.config().client.showTradingStationTooltips) {
            class_5250 label1 = class_2561.method_43469((String)OWNER_LABEL, (Object[])new Object[]{be.getOwnerName().method_27661().method_27692(class_124.field_1065)});
            this.renderLabel(be, (class_2561)label1, 0.0, 0.9, 0.0, 12, matrices, vertexConsumers, light);
            if (!be.getTrade().isEmpty()) {
                class_5250 label2 = class_2561.method_43469((String)SELLING_LABEL, (Object[])new Object[]{AdornUtil.toTextWithCount(be.getTrade().getSelling())});
                class_5250 label3 = class_2561.method_43469((String)PRICE_LABEL, (Object[])new Object[]{AdornUtil.toTextWithCount(be.getTrade().getPrice())});
                this.renderLabel(be, (class_2561)label2, 0.0, 0.65, 0.0, 12, matrices, vertexConsumers, light);
                this.renderLabel(be, (class_2561)label3, 0.0, 0.4, 0.0, 12, matrices, vertexConsumers, light);
            }
        }
    }

    private void renderLabel(class_2586 be, class_2561 label, double x, double y, double z, int maxDistance, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_4184 camera = this.dispatcher.field_4344;
        double dist = be.method_11016().method_10268(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        if (dist < (double)(maxDistance * maxDistance)) {
            matrices.method_22903();
            matrices.method_22904(x + 0.5, y + 1.5, z + 0.5);
            matrices.method_22907((Quaternionfc)camera.method_23767());
            matrices.method_22905(0.025f, -0.025f, 0.025f);
            Matrix4f positionMatrix = matrices.method_23760().method_23761();
            float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
            int backgroundColor = Colors.color(0, opacity);
            float textX = (float)(-this.textRenderer.method_27525((class_5348)label)) * 0.5f;
            this.textRenderer.method_27522(label, textX, 0.0f, 0x20FFFFFF, false, positionMatrix, vertexConsumers, class_327.class_6415.field_33994, backgroundColor, light);
            this.textRenderer.method_27522(label, textX, 0.0f, -1, false, positionMatrix, vertexConsumers, class_327.class_6415.field_33993, 0, light);
            matrices.method_22909();
        }
    }
}

