/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Optional;
import juuxel.adorn.compat.rei.AdornReiServer;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public record BrewerDisplay(EntryIngredient input, EntryIngredient first, EntryIngredient second, EntryIngredient fluid, EntryStack<?> result, Optional<class_2960> id) implements Display
{
    public static final MapCodec<BrewerDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().fieldOf("input").forGetter(BrewerDisplay::input), (App)EntryIngredient.codec().fieldOf("first_ingredient").forGetter(BrewerDisplay::first), (App)EntryIngredient.codec().fieldOf("second_ingredient").forGetter(BrewerDisplay::second), (App)EntryIngredient.codec().fieldOf("fluid").forGetter(BrewerDisplay::fluid), (App)EntryStack.codec().fieldOf("result").forGetter(BrewerDisplay::result), (App)class_2960.field_25139.optionalFieldOf("id").forGetter(BrewerDisplay::id)).apply((Applicative)instance, BrewerDisplay::new));
    public static final class_9139<class_9129, BrewerDisplay> PACKET_CODEC = class_9139.method_58025((class_9139)EntryIngredient.streamCodec(), BrewerDisplay::input, (class_9139)EntryIngredient.streamCodec(), BrewerDisplay::first, (class_9139)EntryIngredient.streamCodec(), BrewerDisplay::second, (class_9139)EntryIngredient.streamCodec(), BrewerDisplay::fluid, (class_9139)EntryStack.streamCodec(), BrewerDisplay::result, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), BrewerDisplay::id, BrewerDisplay::new);
    public static final DisplaySerializer<BrewerDisplay> SERIALIZER = DisplaySerializer.of(MAP_CODEC, PACKET_CODEC);

    public BrewerDisplay(ItemBrewingRecipe recipe, @Nullable class_2960 id) {
        this(EntryIngredients.of((class_1935)((class_1935)AdornItems.MUG.get())), EntryIngredients.ofIngredient((class_1856)recipe.firstIngredient()), recipe.secondIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), EntryIngredient.empty(), EntryStacks.of((class_1799)recipe.result()), Optional.ofNullable(id));
    }

    public BrewerDisplay(FluidBrewingRecipe recipe, @Nullable class_2960 id) {
        this(EntryIngredients.of((class_1935)((class_1935)AdornItems.MUG.get())), EntryIngredients.ofIngredient((class_1856)recipe.firstIngredient()), recipe.secondIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), BrewerDisplay.entryIngredientOf(recipe.fluid()), EntryStacks.of((class_1799)recipe.result()), Optional.ofNullable(id));
    }

    private static EntryIngredient entryIngredientOf(FluidIngredient fluidIngredient) {
        long amount = FluidUnit.convert(fluidIngredient.getAmount(), fluidIngredient.getUnit(), FluidBridge.get().getFluidUnit());
        List<EntryStack> stacks = fluidIngredient.fluid().getFluids().stream().map(fluid -> EntryStacks.of((FluidStack)FluidStack.create((class_3611)fluid, (long)amount, (class_9326)fluidIngredient.components()))).toList();
        return EntryIngredient.of(stacks);
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(this.input, this.first, this.second, this.fluid);
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredient.of(this.result));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AdornReiServer.BREWER;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.id;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

