/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.item.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.variant.BlockKind;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.block.variant.BlockVariantSets;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.item.group.ItemGroupBuildContext;
import juuxel.adorn.item.group.ItemGroupModifyContext;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.RegisteredMap;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.lib.registry.RegistrarFactory;
import juuxel.adorn.platform.ItemGroupBridge;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class AdornItemGroups {
    public static final Registrar<class_1761> ITEM_GROUPS = RegistrarFactory.get().create(class_7924.field_44688);
    private static final List<BlockKind> BUILDING_KINDS = List.of(BlockKind.POST, BlockKind.PLATFORM, BlockKind.STEP);
    private static final List<BlockKind> FUNCTIONAL_KINDS = List.of(BlockKind.CHAIR, BlockKind.TABLE, BlockKind.DRAWER, BlockKind.KITCHEN_COUNTER, BlockKind.KITCHEN_CUPBOARD, BlockKind.KITCHEN_SINK, BlockKind.SHELF, BlockKind.COFFEE_TABLE, BlockKind.BENCH);
    public static final List<class_1767> DYE_COLORS_IN_ORDER = List.of(class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957, class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954);
    private static final String GROUP_ID = "items";
    public static final Registered<class_1761> GROUP = ITEM_GROUPS.register("items", () -> ItemGroupBridge.get().builder().method_47321((class_2561)class_2561.method_43471((String)class_156.method_646((String)"itemGroup", (class_2960)AdornCommon.id(GROUP_ID)))).method_47320(() -> new class_1799((class_1935)AdornBlocks.SOFAS.getEager(class_1767.field_7961))).method_47317((displayContext, entries) -> {
        ItemGroupBuildContext context = arg_0 -> ((class_1761.class_7704)entries).method_45421(arg_0);
        switch (ConfigManager.config().groupItems) {
            case BY_MATERIAL: {
                AdornItemGroups.addByKinds(context, Arrays.asList(BlockKind.values()));
                break;
            }
            case BY_SHAPE: {
                for (BlockKind kind : BlockKind.values()) {
                    for (Registered<class_2248> block : BlockVariantSets.get(kind)) {
                        context.add(block);
                    }
                }
                AdornItemGroups.addColored(context, AdornBlocks.PAINTED_PLANKS);
                AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_STAIRS);
                AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_SLABS);
                AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_FENCES);
                AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_FENCE_GATES);
                AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_PRESSURE_PLATES);
                AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_SLABS);
            }
        }
        AdornItemGroups.addColoredBlocks(context, false);
        AdornItemGroups.addChimneys(context);
        AdornItemGroups.addFences(context);
        AdornItemGroups.addCopperPipes(context);
        AdornItemGroups.addCrates(context);
        AdornItemGroups.addMiscDecorations(context);
        context.add(AdornBlocks.TRADING_STATION);
        context.add(AdornBlocks.BREWER);
        AdornItemGroups.addFoodAndDrink(context);
        AdornItemGroups.addIngredients(context);
        AdornItemGroups.addTools(context);
    }).method_47324());

    public static void init() {
        if (ConfigManager.config().client.showItemsInStandardGroups) {
            AdornItemGroups.addToVanillaItemGroups();
        }
    }

    private static void addToVanillaItemGroups() {
        ItemGroupBridge itemGroups = ItemGroupBridge.get();
        itemGroups.addItems((class_5321<class_1761>)class_7706.field_40195, context -> {
            for (BlockVariant variant : BlockVariantSets.allVariants()) {
                if (variant instanceof BlockVariant.PaintedWood) continue;
                class_2248 after = AdornItemGroups.findLastBuildingBlockEntry(variant);
                if (after != null) {
                    ArrayList<class_1935> items = new ArrayList<class_1935>();
                    for (BlockKind kind : BUILDING_KINDS) {
                        Registered<class_2248> block = BlockVariantSets.get(kind, variant);
                        if (block == null) continue;
                        items.add((class_1935)block.get());
                    }
                    context.addAfter((class_1935)after, items);
                    continue;
                }
                AdornItemGroups.addByKinds(context, variant, BUILDING_KINDS);
            }
            context.addAfter((class_1935)class_1802.field_27035, AdornBlocks.COPPER_PIPE);
            context.addAfter((class_1935)class_1802.field_27036, AdornBlocks.EXPOSED_COPPER_PIPE);
            context.addAfter((class_1935)class_1802.field_27037, AdornBlocks.WEATHERED_COPPER_PIPE);
            context.addAfter((class_1935)class_1802.field_27038, AdornBlocks.OXIDIZED_COPPER_PIPE);
            context.addAfter((class_1935)class_1802.field_27048, AdornBlocks.WAXED_COPPER_PIPE);
            context.addAfter((class_1935)class_1802.field_27049, AdornBlocks.WAXED_EXPOSED_COPPER_PIPE);
            context.addAfter((class_1935)class_1802.field_27050, AdornBlocks.WAXED_WEATHERED_COPPER_PIPE);
            context.addAfter((class_1935)class_1802.field_33406, AdornBlocks.WAXED_OXIDIZED_COPPER_PIPE);
        });
        itemGroups.addItems((class_5321<class_1761>)class_7706.field_41059, context -> AdornItemGroups.addColoredBlocks(context, true));
        itemGroups.addItems((class_5321<class_1761>)class_7706.field_40197, context -> {
            AdornItemGroups.addByKinds(context, FUNCTIONAL_KINDS);
            AdornItemGroups.addColoredBlocks(context, false);
            AdornItemGroups.addChimneys(context);
            AdornItemGroups.addFences(context);
            AdornItemGroups.addCrates(context);
            AdornItemGroups.addMiscDecorations(context);
            context.add(AdornBlocks.TRADING_STATION);
            context.add(AdornBlocks.BREWER);
        });
        itemGroups.addItems((class_5321<class_1761>)class_7706.field_41061, AdornItemGroups::addFoodAndDrink);
        itemGroups.addItems((class_5321<class_1761>)class_7706.field_41062, AdornItemGroups::addIngredients);
        itemGroups.addItems((class_5321<class_1761>)class_7706.field_41060, AdornItemGroups::addTools);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addByKinds(ItemGroupBuildContext context, List<BlockKind> kinds) {
        boolean hasAllKinds = kinds.equals(Arrays.asList(BlockKind.values()));
        Iterator<BlockVariant> iterator = BlockVariantSets.allVariants().iterator();
        while (iterator.hasNext()) {
            BlockVariant variant = iterator.next();
            if (hasAllKinds && variant instanceof BlockVariant.PaintedWood) {
                BlockVariant.PaintedWood paintedWood = (BlockVariant.PaintedWood)variant;
                try {
                    class_1767 class_17672;
                    class_1767 color = class_17672 = paintedWood.color();
                    context.add(AdornBlocks.PAINTED_PLANKS.get(color));
                    context.add(AdornBlocks.PAINTED_WOOD_STAIRS.get(color));
                    context.add(AdornBlocks.PAINTED_WOOD_SLABS.get(color));
                    context.add(AdornBlocks.PAINTED_WOOD_FENCES.get(color));
                    context.add(AdornBlocks.PAINTED_WOOD_FENCE_GATES.get(color));
                    context.add(AdornBlocks.PAINTED_WOOD_PRESSURE_PLATES.get(color));
                    context.add(AdornBlocks.PAINTED_WOOD_BUTTONS.get(color));
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            AdornItemGroups.addByKinds(context, variant, kinds);
        }
        return;
    }

    private static void addByKinds(ItemGroupBuildContext context, BlockVariant variant, List<BlockKind> kinds) {
        for (BlockKind kind : kinds) {
            Registered<class_2248> block = BlockVariantSets.get(kind, variant);
            if (block == null) continue;
            context.add(block);
        }
    }

    private static void addColoredBlocks(ItemGroupBuildContext context, boolean includeWood) {
        AdornItemGroups.addColored(context, AdornBlocks.SOFAS);
        AdornItemGroups.addColored(context, AdornBlocks.TABLE_LAMPS);
        if (includeWood) {
            AdornItemGroups.addColored(context, AdornBlocks.PAINTED_PLANKS);
            AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_STAIRS);
            AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_SLABS);
            AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_FENCES);
            AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_FENCE_GATES);
            AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_PRESSURE_PLATES);
            AdornItemGroups.addColored(context, AdornBlocks.PAINTED_WOOD_BUTTONS);
            for (BlockKind kind : BlockKind.values()) {
                for (class_1767 color : DYE_COLORS_IN_ORDER) {
                    Registered<class_2248> item = BlockVariantSets.get(kind, BlockVariant.PAINTED_WOODS.get(color));
                    if (item == null) continue;
                    context.add(item);
                }
            }
        }
        context.add(AdornBlocks.CANDLELIT_LANTERN);
        AdornItemGroups.addColored(context, AdornBlocks.DYED_CANDLELIT_LANTERNS);
    }

    private static void addColored(ItemGroupBuildContext context, RegisteredMap<class_1767, ? extends class_1935> items) {
        for (class_1767 color : DYE_COLORS_IN_ORDER) {
            context.add(items.get(color));
        }
    }

    private static void addCrates(ItemGroupBuildContext context) {
        context.add(AdornBlocks.CRATE);
        context.add(AdornBlocks.APPLE_CRATE);
        context.add(AdornBlocks.WHEAT_CRATE);
        context.add(AdornBlocks.CARROT_CRATE);
        context.add(AdornBlocks.POTATO_CRATE);
        context.add(AdornBlocks.MELON_CRATE);
        context.add(AdornBlocks.WHEAT_SEED_CRATE);
        context.add(AdornBlocks.MELON_SEED_CRATE);
        context.add(AdornBlocks.PUMPKIN_SEED_CRATE);
        context.add(AdornBlocks.BEETROOT_CRATE);
        context.add(AdornBlocks.BEETROOT_SEED_CRATE);
        context.add(AdornBlocks.SWEET_BERRY_CRATE);
        context.add(AdornBlocks.COCOA_BEAN_CRATE);
        context.add(AdornBlocks.NETHER_WART_CRATE);
        context.add(AdornBlocks.SUGAR_CANE_CRATE);
        context.add(AdornBlocks.EGG_CRATE);
        context.add(AdornBlocks.HONEYCOMB_CRATE);
        context.add(AdornBlocks.LIL_TATER_CRATE);
    }

    private static void addChimneys(ItemGroupBuildContext context) {
        context.add(AdornBlocks.BRICK_CHIMNEY);
        context.add(AdornBlocks.STONE_BRICK_CHIMNEY);
        context.add(AdornBlocks.NETHER_BRICK_CHIMNEY);
        context.add(AdornBlocks.RED_NETHER_BRICK_CHIMNEY);
        context.add(AdornBlocks.COBBLESTONE_CHIMNEY);
        context.add(AdornBlocks.PRISMARINE_CHIMNEY);
        context.add(AdornBlocks.MAGMATIC_PRISMARINE_CHIMNEY);
        context.add(AdornBlocks.SOULFUL_PRISMARINE_CHIMNEY);
    }

    private static void addFences(ItemGroupBuildContext context) {
        context.add(AdornBlocks.PICKET_FENCE);
        context.add(AdornBlocks.CHAIN_LINK_FENCE);
    }

    private static void addCopperPipes(ItemGroupBuildContext context) {
        context.add(AdornBlocks.COPPER_PIPE);
        context.add(AdornBlocks.EXPOSED_COPPER_PIPE);
        context.add(AdornBlocks.WEATHERED_COPPER_PIPE);
        context.add(AdornBlocks.OXIDIZED_COPPER_PIPE);
        context.add(AdornBlocks.WAXED_COPPER_PIPE);
        context.add(AdornBlocks.WAXED_EXPOSED_COPPER_PIPE);
        context.add(AdornBlocks.WAXED_WEATHERED_COPPER_PIPE);
        context.add(AdornBlocks.WAXED_OXIDIZED_COPPER_PIPE);
    }

    private static void addFoodAndDrink(ItemGroupBuildContext context) {
        context.add(AdornItems.MUG);
        context.add(AdornItems.HOT_CHOCOLATE);
        context.add(AdornItems.SWEET_BERRY_JUICE);
        context.add(AdornItems.GLOW_BERRY_TEA);
        context.add(AdornItems.NETHER_WART_COFFEE);
    }

    private static void addIngredients(ItemGroupBuildContext context) {
        if (context instanceof ItemGroupModifyContext) {
            ItemGroupModifyContext modifyContext = (ItemGroupModifyContext)context;
            modifyContext.addAfter((class_1935)class_1802.field_8600, AdornItems.STONE_ROD);
            modifyContext.addAfter((class_1935)class_1802.field_8675, AdornItems.COPPER_NUGGET);
        } else {
            context.add(AdornItems.STONE_ROD);
            context.add(AdornItems.COPPER_NUGGET);
        }
    }

    private static void addTools(ItemGroupBuildContext context) {
        context.add(AdornItems.WATERING_CAN);
        context.add(AdornItems.GUIDE_BOOK);
        context.add(AdornItems.TRADERS_MANUAL);
    }

    private static void addMiscDecorations(ItemGroupBuildContext context) {
        context.add(AdornItems.STONE_TORCH);
        context.add(AdornBlocks.STONE_LADDER);
    }

    private static List<class_1935> getPaintedWood() {
        ArrayList<class_1935> items = new ArrayList<class_1935>();
        for (class_1767 color : DYE_COLORS_IN_ORDER) {
            items.add((class_1935)AdornBlocks.PAINTED_PLANKS.getEager(color));
            items.add((class_1935)AdornBlocks.PAINTED_WOOD_SLABS.getEager(color));
            items.add((class_1935)AdornBlocks.PAINTED_WOOD_STAIRS.getEager(color));
            items.add((class_1935)AdornBlocks.PAINTED_WOOD_FENCES.getEager(color));
            items.add((class_1935)AdornBlocks.PAINTED_WOOD_FENCE_GATES.getEager(color));
            items.add((class_1935)AdornBlocks.PAINTED_WOOD_PRESSURE_PLATES.getEager(color));
            items.add((class_1935)AdornBlocks.PAINTED_WOOD_BUTTONS.getEager(color));
        }
        return items;
    }

    @Nullable
    private static class_2248 findLastBuildingBlockEntry(BlockVariant variant) {
        return AdornItemGroups.findBaseBlock(variant, "button").or(() -> AdornItemGroups.findBaseBlock(variant, "wall")).or(() -> AdornItemGroups.findBaseBlock(variant, "slab")).or(() -> AdornItemGroups.findBaseBlock(variant, null)).orElse(null);
    }

    private static Optional<class_2248> findBaseBlock(BlockVariant variant, @Nullable String suffix) {
        class_2960 buttonId;
        class_2960 variantId = variant.nameAsIdentifier();
        class_2960 class_29602 = buttonId = suffix != null ? variantId.method_48331("_" + suffix) : variantId;
        if (class_7923.field_41175.method_10250(buttonId)) {
            return Optional.of((class_2248)class_7923.field_41175.method_63535(buttonId));
        }
        return Optional.empty();
    }
}

