/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.fabric;

import juuxel.adorn.fluid.FluidAmountPredicate;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import juuxel.adorn.platform.FluidBridge;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public final class FluidBridgeFabric
implements FluidBridge {
    @Override
    public FluidUnit getFluidUnit() {
        return FluidUnit.DROPLET;
    }

    @Override
    @Nullable
    public FluidVolume drain(class_1937 world, class_2338 pos, @Nullable class_2680 state, class_2350 side, class_3611 fluid, FluidAmountPredicate amountPredicate) {
        Storage storage = (Storage)FluidStorage.SIDED.find(world, pos, state, null, (Object)side);
        if (storage != null) {
            HasFluidAmount upperBound = amountPredicate.getUpperBound();
            long maxAmount = FluidUnit.convert(upperBound.getAmount(), upperBound.getUnit(), FluidUnit.DROPLET);
            try (Transaction transaction = Transaction.openOuter();){
                long extracted = storage.extract((Object)FluidVariant.of((class_3611)fluid), maxAmount, (TransactionContext)transaction);
                if (extracted > 0L && amountPredicate.test(extracted, FluidUnit.DROPLET)) {
                    transaction.commit();
                    FluidVolume fluidVolume = new FluidVolume(fluid, extracted, class_9326.field_49588, FluidUnit.DROPLET);
                    return fluidVolume;
                }
            }
        }
        return null;
    }
}

