/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import juuxel.adorn.util.Fractions;

public final class MixedFraction {
    private final long whole;
    private final long numerator;
    private final long denominator;

    private MixedFraction(long whole, long numerator, long denominator) {
        if (numerator < 0L) {
            throw new IllegalArgumentException("Numerator must not be negative, was " + numerator);
        }
        if (denominator <= 0L) {
            throw new IllegalArgumentException("Denominator must not be 0 or negative, was " + numerator);
        }
        if (denominator == 1L && numerator != 0L) {
            throw new IllegalArgumentException("Denominator 1 is only allowed when numerator == 0, was " + numerator);
        }
        this.whole = whole;
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public MixedFraction resizeFraction(long newDenominator) {
        if (this.numerator == 0L) {
            return this;
        }
        return new MixedFraction(this.whole, this.numerator * newDenominator / this.denominator, newDenominator);
    }

    public String toString() {
        return Fractions.toString(this.whole, this.numerator, this.denominator);
    }

    public static MixedFraction whole(long n) {
        return new MixedFraction(n, 0L, 1L);
    }

    public static MixedFraction of(long numerator, long denominator) {
        if (denominator == 1L) {
            return new MixedFraction(numerator, 0L, 1L);
        }
        long realNumerator = numerator % denominator;
        long whole = (numerator - realNumerator) / denominator;
        return new MixedFraction(whole, realNumerator, denominator);
    }
}

